# 📞 Phone Number Validation & Formatter API (R SDK)

The `PhoneValidator` R package is the official client for the [GenderAPI Phone Number Validation & Formatter API](https://www.genderapi.io/docs-phone-validation-formatter-api), enabling you to validate and format phone numbers from over 240 countries worldwide.

Whether your users provide phone numbers in various formats (e.g., `12128675309`, `+1 212 867 5309`, `001–212–867–5309`), this package intelligently detects, validates, and converts the input into a standardized [E.164](https://en.wikipedia.org/wiki/E.164) format (e.g., `+12128675309`).

---

## ✅ Features

- Converts phone numbers to **E.164** format
- Validates if a number is **valid** and **structurally possible**
- Detects number type: **mobile**, **landline**, **VoIP**, etc.
- Identifies **region/city** based on area code
- Includes **country-level metadata** (e.g., ISO code, time zone)
- Built with R and powered by **GenderAPI.io**

---

## 📦 Installation

Since this package is not yet on CRAN, you can install it directly from GitHub:

```r
# Install devtools if not already installed
install.packages("devtools")

# Install the PhoneValidator package
devtools::install_github("GenderAPI/PhoneValidator-R")
```

---

## 🚀 Usage

```r
library(PhoneValidator)

result <- validate(
  api_key = "YOUR_API_KEY",
  number = "+1 212 867 5309",
  address = "US"  # Optional, improves parsing of local numbers
)

print(result)
```

---

## 🧾 Input Parameters

| Parameter  | Type   | Required | Description |
|------------|--------|----------|-------------|
| `number`   | string | ✅ Yes   | Phone number in any format |
| `address`  | string | Optional | Can be a country code (`US`), full country name (`Turkey`), or city name (`Berlin`) to improve parsing |

```r
validate(api_key = "YOUR_API_KEY", number = "12128675309", address = "US")
```

---

## 📤 API Response Example

```json
{
  "status": true,
  "remaining_credits": 15709,
  "expires": 0,
  "duration": "18ms",
  "regionCode": "US",
  "countryCode": 1,
  "country": "United States",
  "national": "(212) 867–5309",
  "international": "+1 212-867-5309",
  "e164": "+12128675309",
  "isValid": true,
  "isPossible": true,
  "numberType": "FIXED_LINE_OR_MOBILE",
  "nationalSignificantNumber": "12128675309",
  "rawInput": "+1 212 867 5309",
  "isGeographical": true,
  "areaCode": "212",
  "location": "New York City (Manhattan)"
}
```

---

## 📚 Response Fields

| Field                   | Type    | Description                                  |
|------------------------|---------|----------------------------------------------|
| `status`               | Boolean | Was the request successful                   |
| `remaining_credits`    | Integer | Remaining API credits                        |
| `regionCode`           | String  | ISO 3166-1 alpha-2 code (e.g., `US`)         |
| `country`              | String  | Country name                                 |
| `e164`                 | String  | Number formatted to E.164                    |
| `isValid`              | Boolean | Is number valid according to numbering rules |
| `isPossible`           | Boolean | Is number structurally possible              |
| `numberType`           | String  | Type of number (mobile, VoIP, etc.)          |
| `areaCode`             | String  | Area code from input                         |
| `location`             | String  | City/region matched from area code           |

---

## 🔢 Number Type Values

| Value                  | Description                        |
|------------------------|------------------------------------|
| `FIXED_LINE`           | Landline                           |
| `MOBILE`               | Mobile phone                       |
| `FIXED_LINE_OR_MOBILE` | Could be both                      |
| `TOLL_FREE`            | e.g. 800 numbers                   |
| `PREMIUM_RATE`         | Expensive premium numbers          |
| `SHARED_COST`          | Shared between parties             |
| `VOIP`                 | Internet-based number              |
| `PERSONAL_NUMBER`      | Forwarding number                  |
| `PAGER`                | Obsolete pager number              |
| `VOICEMAIL`            | Voicemail access                   |
| `UNKNOWN`              | Cannot be determined               |

---

## ℹ️ More Information

- Supports 240+ countries and territories
- Auto-detects landline vs. mobile numbers
- Useful for CRM, form validation, user profiling
- Full API documentation: [GenderAPI Phone Validation Docs](https://www.genderapi.io/docs-phone-validation-formatter-api)

---

## 📝 License

MIT License © [GenderAPI](https://www.genderapi.io)
