% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_public.R
\name{VDJ_public}
\alias{VDJ_public}
\title{Function to get shared/public elements across multiple repertoires}
\usage{
VDJ_public(
  VDJ,
  feature.columns,
  grouping.column,
  specific.groups,
  find.public.all,
  find.public.percentage,
  treat.combined.features,
  output.format
)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{feature.columns}{Character or character vector columns of features to be assayed}

\item{grouping.column}{string - the repertoire/group-defining column (default to 'sample_id').}

\item{specific.groups}{vector of strings or NULL - if only the shared elements from specific repertoires should be taken into account. If NULL, will output the shared/public elements across all repertoires.}

\item{find.public.all}{boolean - if T, will look for the public elements across all repertoires}

\item{find.public.percentage}{list - the first element denotes the percentage of repertoires to get shared elements for, the second element is the maximum number of repertoire combinations to consider (can be NULL to consider all).}

\item{treat.combined.features}{string - 'exclude' will exclude combined features with one element missing, 'include' will include and considers them as a new feature value.}

\item{output.format}{string - 'df' to get a shared element dataframe (with columns = Repertoire and Public), 'list' for a list of shared elements.}
}
\value{
Either a dataframe of public elements across multiple repertoires or a list.
}
\description{
Function to get shared elements across multiple repertoires, specified by the feature.columns parameter (a column of the VDJ matrix). If two columns are specified in feature.columns, the resulting shared features will combine the values from each column (at a per-cell level).
}
\examples{
VDJ_get_public(VDJ = small_vgm[[1]],
feature.columns='VDJ_cdr3s_aa', find.public.all=TRUE,
output.format='df')

}
