% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VGM_build.R
\name{VGM_build}
\alias{VGM_build}
\title{Function to obtain the VGM object by integrating the VDJ and GEX/Seurat objects}
\usage{
VGM_build(VDJ, GEX, merge.by, additional.dataframes, columns.to.transfer)
}
\arguments{
\item{VDJ}{VDJ data frame, obtained from the Platypus VDJ() function}

\item{GEX}{Seurat object for the single-cell immune receptor repertoire analysis.}

\item{merge.by}{string - the column name to match both objects/dataframes by. Should be present in both objects (Seurat object meta.data and VDJ dataframe). Defaults to "barcode."}

\item{additional.dataframes}{vector of data frames - additional dataframes to be matched/merged to the VDJ and GEX. Will be matched by the column denoted in the merge.by parameter (should be present in the VDJ and all subsequent dataframes).}

\item{columns.to.transfer}{string or vector of strings - columns that should be transferred/appended across all objects (matched by the merge.by parameter). Defaults to "all" - all unique columns from GEX not present in VDJ and vice-versa.}
}
\value{
An output VGM object: a list with the first element - the VDJ object; second element - the GEX/Seurat object. Additonal elements are appended to the list if additional.dataframes is not null.
}
\description{
Takes as input a VDJ data frame (as obtained from the VDJ function in Platypus) and a Seurat object. Outputs an integrated VGM object (a list with the first element - the VDJ object; second element - the Seurat object).
Integration involves matching by barcodes and adding all features from one object to the other and vice-versa.
Authors: Tudor-Stefan Cotet, Victor Kreiner
}
\examples{
\donttest{
try({
small_vgm <- VGM_build(
VDJ = small_vgm[[1]],
GEX = small_vgm[[2]],
columns.to.transfer = 'all') #transfer all new columns
})
}
}
