% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{MLE}
\alias{MLE}
\title{Maximum Likelihood estimation}
\usage{
MLE(params,
    nondiseasedTiters,
    diseasedTiters,
    adjustTiters = FALSE,
    adjustFrom = log2(10),
    adjustTo = log2(5))
}
\arguments{
\item{params}{named numeric vector: PoD curve parameters (et50, slope, pmax)}

\item{nondiseasedTiters}{numeric vector: non-diseased subjects titers}

\item{diseasedTiters}{numeric vector: diseased subjects titers}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}
}
\value{
log likelihood, numeric value
}
\description{
Function calculates the log likelihood value which is used after the initial guesses of the parameters are set in the \code{PoDMLE} function.
}
\details{
MLE function is used inside of PoDMLE function and esimates the PoD curve parameters.

Based on the provided titers for diseased and non-diseased subjects the PoD curve parameters which maximize the log likelihood are chosen as optimal estimates of parameters.
}
\examples{
# Data preparation
data(diseased)
data(nondiseased)
data(PoDParams)

# MLE calculation
MLE(PoDParams, nondiseased$titers, diseased$titers)

}
