% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_vis_lr.R
\name{dot_plot}
\alias{dot_plot}
\title{Create Ligand-Receptor Interaction Dot Plot}
\usage{
dot_plot(
  filtered_lr,
  top_n = 5,
  axis = c("LR-SR", "SR-LR"),
  type_scale = c("size", "radius"),
  selected_LR = NULL
)
}
\arguments{
\item{filtered_lr}{A data frame containing ligand-receptor interaction data.}

\item{top_n}{Integer specifying the number of top interactions to select per sender-receiver pair (numeric, default: 5).}

\item{axis}{Character indicating the configuration of rows and columns in the plot.
Options: "LR-SR" (default, rows = ligand-receptor pairs, columns = sender-receiver pairs) or "SR-LR".}

\item{type_scale}{Character indicating the scaling method for the plot.
Options: "size" (default, uses \code{scale_size()} for point scaling) or "radius" (uses \code{scale_radius()} for point scaling).}

\item{selected_LR}{Optional character vector of ligand-receptor pair identifiers (e.g., c("TIMP1_CD63", "DSCAM_DCC")).
If NULL, the top_n interactions per sender-receiver pair are used.}
}
\value{
A ggplot object representing the dot plot.
}
\description{
Generates a dot plot to visualize ligand-receptor (LR) interaction. Dot sizes are scaled by the correlation
coefficient and dot colors represent -log10(adjust.p). The function supports plotting the top interactions
per sender-receiver pair or user-specified ligand-receptor pairs.
}
\examples{
# Plot LR Interaction Dot Plot
data(filtered_lr_eg)
p <- dot_plot(filtered_lr_eg, axis = "LR-SR", type_scale = "size")
print(p)
}
