% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABMToCova.R
\name{ABMToCova}
\alias{ABMToCova}
\title{Creates the four data frames of weighted contact pairs for use in Covasim}
\usage{
ABMToCova(
  ABMPop,
  ABMID,
  ABMAge,
  place1,
  place2,
  ECE = TRUE,
  PSchool = TRUE,
  SSchool = TRUE,
  contacts = NULL,
  excludeDF = NULL
)
}
\arguments{
\item{ABMPop}{The agent-based modelling data frame.}

\item{ABMID}{The variable containing the unique identifier for each person, in the ABMPop data frame.}

\item{ABMAge}{The variable containing the ages, in the in the ABMPop data frame.}

\item{place1}{The variable containing the Household ID.}

\item{place2}{The variable containing the school and workplace IDs.}

\item{ECE}{Are ECE centres open? Default is TRUE, change to FALSE if ECEs are to close.}

\item{PSchool}{Are primary schools open? Default is TRUE, change to FALSE if primary schools are to close.}

\item{SSchool}{Are secondary schools open? Default is TRUE, change to FALSE if secondary schools are to close.}

\item{contacts}{A data frame consisting of existing contact pairs. The first two variables define the two people in the pair.}

\item{excludeDF}{A data frame of industries to exclude. This must be the relevant IndNum variable in the ABMPop data frame. If this data frame is not included, all industries will be represented in the output data frame.}
}
\value{
A data frame of the household, school, workplace, contact layers, and people's ages, for use in Covasim.
}
\description{
Creates the household, school, workplace, and contacts layers, from ABMPop, for use with the Python package Covasim. A 1xn data frame of ages is also created.
}
\details{
There are three restrictions for use. First, the place2 codes for preschool, primary school, and secondary school must be set to "P801000", "P802100", and "P802200", respectively. Second, at least one school type must be "TRUE" as Covasim requires a school layer. Third, the place2 value for people who are not in school, and not in a workplace, must be "Not employed".
}
