% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funcs.R
\name{get_distributions_single}
\alias{get_distributions_single}
\title{Get PDF distribution}
\usage{
get_distributions_single(
  matrix_entry,
  distribution_list,
  asymp_stab,
  points = 250
)
}
\arguments{
\item{matrix_entry}{Position in the matrix. Example: c(1, 1)}

\item{distribution_list}{list of scipy distributions}

\item{asymp_stab}{asymptotic stability interval}

\item{points}{the number of values in x range}
}
\value{
Probability Distribution Function from scipy
}
\description{
This function retrieves the PDF (Probability Distribution Function)
object from the scipy method 
<scipy.stats._distn_infrastructure.rv_frozen>.
}
\examples{
\dontrun{
k <- 1
l <- 1
np <- reticulate::import("numpy")
distributions <- reticulate::py_load_object("distributions.pkl")
single_dist <- get_distributions_single(matrix_entry = c(k,l), 
    distribution_list = distributions, 
    asymp_stab = c(combined$asymptotic_stability_start[k,l], 
    combined$asymptotic_stability_end[k,l]))
}
}
