% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FullElevGapFunctions.R
\name{fullElevGapShrink}
\alias{fullElevGapShrink}
\title{Shrink the width of full elevation and gap patterns}
\usage{
fullElevGapShrink(
  minCov,
  windowSize,
  maxCov,
  elevLength,
  nonElev,
  bestMatchInfo,
  pileupSubset,
  minSize,
  elevOrGap
)
}
\arguments{
\item{minCov}{The minimum value of the pattern-match vector.}

\item{windowSize}{The number of basepairs to average read coverage values over.
Options are 100, 200, 500, 1000 ONLY. Default is 1000.}

\item{maxCov}{The maximum value of the pattern-match vector.}

\item{elevLength}{Length of the elevated/gapped pattern-match region.}

\item{nonElev}{Length of the non-elevated/gapped pattern-match region.}

\item{bestMatchInfo}{The information associated with the current best pattern-match
for the contig/chunk being assessed.}

\item{pileupSubset}{A subset of the pileup that pertains only to the contig/chunk
currently being assessed.}

\item{minSize}{The minimum size (in bp) of elevation or gap patterns. Default is 10000.}

\item{elevOrGap}{Pattern-matching on 'elevation' or 'gap' pattern.}
}
\description{
Remove values from gapped/elevated region in the pattern-match vector
until it reaches the `minSize`
}
\keyword{internal}
