% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_two_member_vote_positions.R
\name{compare_two_member_vote_positions}
\alias{compare_two_member_vote_positions}
\title{Compare Two Members Vote Positions}
\usage{
compare_two_member_vote_positions(
  first_member_id,
  second_member_id,
  congress,
  chamber,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{first_member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{second_member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{congress}{102-116 for House, 101-116 for Senate}

\item{chamber}{house or senate}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves four calculated values: common_votes, disagree_votes, agree_percent and disagree_percent to compare two members’ vote positions, in a particular Congress and chamber
}
\description{
Use this request type to compare two members’ vote positions in a particular Congress and chamber. Responses include four calculated values, showing the number and percentage of votes in which the members took the same position or opposing positions. HTTP Request: GET https://api.propublica.org/congress/v1/members/{first-member-id}/votes/{second-member-id}/{congress}/{chamber}.json
}
\examples{
\dontrun{
compare_two_member_vote_positions('G000575', 'D000624', '114', 'house')
}
}
