% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_congressional_statement_by_member.R
\name{get_congressional_statement_by_member}
\alias{get_congressional_statement_by_member}
\title{Get Congressional Statements by Member}
\usage{
get_congressional_statement_by_member(member_id, congress, page = 1, myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{congress}{113-116}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results and supports pagination using multiples of 20.
}
\description{
Get lists of statements published on a specific member’s congressional website during a particular congress, use the following function.
}
\examples{
\dontrun{
get_congressional_statement_by_member("C001084", 115)
}
}
