% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_info.R, R/samples.R
\name{pt2_length}
\alias{pt2_length}
\alias{pt2_length<-}
\alias{pt2_n_pattern}
\alias{pt2_pattern_table}
\alias{pt2_name}
\alias{pt2_name.pt2mod}
\alias{pt2_name.pt2samp}
\alias{pt2_n_sample}
\title{Obtain ProTracker module information}
\usage{
pt2_length(mod, ...)

pt2_length(mod, ...) <- value

pt2_n_pattern(mod, ...)

pt2_pattern_table(mod, ...)

pt2_name(x, ...)

\method{pt2_name}{pt2mod}(x, ...)

\method{pt2_name}{pt2samp}(x, ...)

pt2_n_sample(mod, ...)
}
\arguments{
\item{...}{Ignored}

\item{value}{New length of a module in number of patterns in the pattern
sequence table.}

\item{x, mod}{A \code{pt2mod} class object for which to obtain information. For \code{x}
also samples of class \code{pt2samp} are allowed as input.}
}
\value{
Returns information about the specified ProTracker module
}
\description{
Obtain information about a protracker module or embedded samples.
}
\examples{
mod <- pt2_read_mod(pt2_demo())

pt2_length(mod)
pt2_n_pattern(mod)
pt2_n_sample(mod)
pt2_pattern_table(mod)
pt2_name(mod)
}
\author{
Pepijn de Vries
}
