% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{l_CV}
\alias{l_CV}
\title{K-Fold Cross validation for L1/L2 regression}
\usage{
l_CV(data,y,x,lambda,k,mode=2,binary=FALSE,step=1000,bound=0.5,fista=TRUE,tol=10^-7)
}
\arguments{
\item{data}{name of the dataset}

\item{y}{name of the dependent variables}

\item{x}{name of the independent variable}

\item{lambda}{a number or a vector of lambda-value to be evaluated in the regression}

\item{k}{integer, which indicates how many training and test set will be splited from the dataset}

\item{mode}{1: ridge regression; 2: lasso regression}

\item{binary}{logical, if TRUE, the dependent variable is binary}

\item{step}{maximum number of steps}

\item{bound}{threshold for binary dependent variable}

\item{fista}{logical, if TRUE, the FISTA algorithm is used}

\item{tol}{tolerance for convergence, it is 10^-7 by default}
}
\value{
the lambda values that minimize the MSE
}
\description{
the function realizes K-Fold Cross validation for ridge/Lasso regression
to help to choose the lambda that minimise the RSS
}
\examples{
l_CV(mtcars,"hp",c("mpg","qsec","disp"),c(0.01,0.1),k=5,mode=2)
}
