% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getter_functions.R
\name{section}
\alias{section}
\alias{section.PugViewInstance}
\alias{section.PugViewSectionList}
\alias{section.PugViewSection}
\title{Extract Sections from Pug View Request}
\usage{
section(object, ...)

\method{section}{PugViewInstance}(object, .id = "S1", .verbose = FALSE, ...)

\method{section}{PugViewSectionList}(object, .id = "S1", .verbose = FALSE, ...)

\method{section}{PugViewSection}(object, .id = "S1", .verbose = FALSE, ...)
}
\arguments{
\item{object}{an object returned from \link{get_pug_view}.}

\item{...}{other arguments. Currently has no effect on the outputs. Can be ignored.}

\item{.id}{A character value that corresponds to the ID of a specific section. Detailed information about the section with the given section ID will be returned. If NULL, the first section (i.e., "S1") is returned. If there is no section under \code{object}, it returns NULL with a warning. See Note/Details for more information.}

\item{.verbose}{A logical value. Should the resulting object be printed to the R console? If TRUE, the object is returned invisibly and the output is printed nicely to the R console. This option may not be available for some slots (or classes). See Notes/Details.}
}
\description{
\code{section} returns section details from a Pug View request.
}
\note{
\subsection{Sections in a Pug View Request}{
A Pug View Request returns a detailed list from the PubChem database. This list may include data under many nested
sections, each corresponding to a different property structured within further nested sections. The
complicated structure of the returned object makes it impossible to print all information to the R console at once.
Therefore, it is recommended to print sections selectively.
Furthermore, one may navigate through the nested sections using the \link{section} function. See Examples.

Use the \link{sectionList} function to list available sections (or subsections of a section) of a Pug View request and related section IDs.
}

\subsection{Use of \code{'.verbose'} to Print Section Details}{
It is possible to print section details to the R console. If \code{.verbose = TRUE}, the resulting object is returned invisibly and a summary of section details is printed to the R console. This might be useful to navigate through nested sections and sequentially print multiple sections to the R console. For example, consider following command:

\code{> section(section(request, "S1", .verbose = TRUE), "S3", .verbose = TRUE)}

This command will print section "S1" and the subsection "S3" located under "S1" to the R console. One may navigate through sections under other sections, similar to exploring dreams within dreams as depicted in the exceptional movie \bold{Inception}. (\bold{SPOILER WARNING!!}) However, be careful not to get lost or stuck in the dreams!! Also, note that this strategy works only if \code{.verbose = TRUE} for all sections and/or subsections.
}
}
\examples{
# Pug View request for the compound "aspirin (CID = 2244)".
pview <- get_pug_view(identifier = "2244", annotation = "data", domain = "compound")

section(pview, "S1")
section(pview, "S1", .verbose = TRUE)

# List all available sections
sectionList(pview)

# Subsections under the section "S1"
sectionList(section(pview, "S1"))

# Print multiple sections
# section(section(pview, "S1", .verbose = TRUE), "S3", .verbose = TRUE)

}
\seealso{
\link{sectionList}
}
