% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload.R
\name{upload_dgm}
\alias{upload_dgm}
\alias{upload_dgm_datasets}
\alias{upload_dgm_results}
\alias{upload_dgm_measures}
\title{Upload Datasets of a DGM}
\usage{
upload_dgm_datasets(dgm_name, overwrite = FALSE, progress = TRUE, max_try = 10)

upload_dgm_results(dgm_name, overwrite = FALSE, progress = TRUE, max_try = 10)

upload_dgm_measures(dgm_name, overwrite = TRUE, progress = TRUE, max_try = 10)
}
\arguments{
\item{dgm_name}{Character string specifying the name of the DGM dataset to upload.}

\item{overwrite}{Logical indicating whether to overwrite existing files on OSF.
Defaults to \code{TRUE} for performance measures and \code{FALSE} for results and datasets}

\item{progress}{Logical indicating whether to show progress uploading files. Defaults to \code{TRUE}.}

\item{max_try}{Integet specifying how many times should the function attempt reconnecting to OSF upon failure.}
}
\value{
\code{TRUE} if the upload was successful, otherwise an error is raised.
}
\description{
This function uploads datasets of a specified Data-Generating Mechanism (DGM)
to the OSF repository at \url{https://osf.io/exf3m/}.

This is an internal function intended for the benchmark maintainer.
It requires OSF repository authentication (via \code{osfr::osf_auth()})
and repository access.
}
\keyword{internal}
