% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PurpleAirAPI.R
\name{getPurpleairSensors}
\alias{getPurpleairSensors}
\title{getPurpleairSensors}
\usage{
getPurpleairSensors(
  apiReadKey = NULL,
  fields = c("latitude", "longitude", "date_created", "last_seen")
)
}
\arguments{
\item{apiReadKey}{API key for accessing the PurpleAir API.}

\item{fields}{Vector specifying the fields to retrieve from PurpleAir API.

Default: c("latitude", "longitude", "date_created", "last_seen")}
}
\value{
A data frame containing the required fields for all PurpleAir sensors
}
\description{
Retrieves data from PurpleAir sensors based on specified fields.
}
\details{
Available fields:\tabular{ll}{
  \code{Station Information and Status} \tab name, icon, model,
   hardware, location_type, private, latitude, longitude, altitude,
    position_rating, led_brightness, firmware_version, firmware_upgrade,
     rssi, uptime, pa_latency, memory, last_seen, last_modified, 
     date_created, channel_state, channel_flags, channel_flags_manual,
      channel_flags_auto, confidence, confidence_manual, confidence_auto \cr
  \tab \cr
  \code{Environmental} \tab humidity, humidity_a, humidity_b,
   temperature, temperature_a, temperature_b, pressure, pressure_a,
    pressure_b \cr
  \tab \cr
  \code{Miscellaneous} \tab voc, voc_a, voc_b, ozone1,
   analog_input \cr
  \tab \cr
  \code{PM1.0} \tab pm1.0, pm1.0_a, pm1.0_b, pm1.0_atm, 
  pm1.0_atm_a, pm1.0_atm_b, pm1.0_cf_1, pm1.0_cf_1_a, pm1.0_cf_1_b \cr
  \tab \cr
  \code{PM2.5} \tab pm2.5_alt, pm2.5_alt_a, pm2.5_alt_b,
   pm2.5, pm2.5_a, pm2.5_b, pm2.5_atm, pm2.5_atm_a, pm2.5_atm_b,
    pm2.5_cf_1, pm2.5_cf_1_a, pm2.5_cf_1_b \cr
  \tab \cr
  \code{Visibility} \tab scattering_coefficient,
   scattering_coefficient_a, scattering_coefficient_b, deciviews, 
   deciviews_a, deciviews_b, visual_range, visual_range_a, visual_range_b \cr
  \tab \cr
  \code{Particle Count} \tab 0.3_um_count, 0.3_um_count_a,
   0.3_um_count_b, 0.5_um_count, 0.5_um_count_a, 0.5_um_count_b,
    1.0_um_count, 1.0_um_count_a, 1.0_um_count_b, 2.5_um_count,
     2.5_um_count_a, 2.5_um_count_b, 5.0_um_count, 5.0_um_count_a,
      5.0_um_count_b, 10.0_um_count, 10.0_um_count_a, 10.0_um_count_b \cr
  \tab \cr
  \code{ThingSpeak} \tab primary_id_a, primary_key_a,
   secondary_id_a, secondary_key_a, primary_id_b, primary_key_b,
    secondary_id_b, secondary_key_b \cr
}
}
\examples{
\dontrun{
# Get sensor data with default fields
sensors <- getPurpleairSensors(apiReadKey = "YOUR_API_KEY")

# Get sensor data with custom fields
sensors <- getPurpleairSensors(
  apiReadKey = "YOUR_API_KEY",
  fields = c("latitude", "longitude", "date_created", "last_seen",
   "location_type")
)
}

}
\references{
For more details on the available fields, see the PurpleAir API 
documentation:
\url{https://api.purpleair.com/#api-sensors-get-sensors-data}
}
