% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_get_metadata}
\alias{gigwa_get_metadata}
\title{Get the Metadata of the Current Active GIGWA Run}
\usage{
gigwa_get_metadata()
}
\value{
A data frame containing metadata attributes for each sample in the active run.
}
\description{
Retrieve metadata associated with the samples in the current active run, set 
using the \code{gigwa_set_run()} function. The metadata provides additional 
information about the samples in the selected run.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("3kG_10M")
  gigwa_set_project("3003_ind")
  gigwa_set_run("1")
  metadata <- gigwa_get_metadata()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_run}}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
