% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QGA.R
\name{QGA}
\alias{QGA}
\title{Quantum Genetic Algorithm}
\usage{
QGA(
  popsize = 20,
  generation_max = 200,
  nvalues_sol,
  Genome,
  thetainit = 3.1415926535 * 0.05,
  thetaend = 3.1415926535 * 0.025,
  pop_mutation_rate_init = NULL,
  pop_mutation_rate_end = NULL,
  mutation_rate_init = NULL,
  mutation_rate_end = NULL,
  mutation_flag = TRUE,
  plotting = TRUE,
  verbose = TRUE,
  progress = TRUE,
  eval_fitness,
  eval_func_inputs,
  stop_limit = NULL
)
}
\arguments{
\item{popsize}{the number of generated solutions (population) to be evaluated at each iteration
(default is 20)}

\item{generation_max}{the number of iterations to be performed
(default is 200)}

\item{nvalues_sol}{the number of possible integer values contained in each element (gene) of the solution}

\item{Genome}{the length of the genome (or chromosome), representing a possible solution}

\item{thetainit}{the angle (expressed in radiants) to be used when applying the rotation gate
when starting the iterations 
(default is pi * 0.05, where pi = 3.1415926535)}

\item{thetaend}{the angle (expressed in radiants) to be used when applying the rotation gate 
at the end of the iterations
(default is pi * 0.025, where pi = 3.1415926535)}

\item{pop_mutation_rate_init}{initial mutation rate to be used when applying the X-Pauli gate, applied 
to each individual in the population (default is 1/(popsize+1))}

\item{pop_mutation_rate_end}{final mutation rate to be used when applying the X-Pauli gate, applied 
to each individual in the population (default is 1/(popsize+1))}

\item{mutation_rate_init}{initial mutation rate to be used when applying the X-Pauli gate, applied 
to each element of the chromosome  (default is 1/(Genome+1)))}

\item{mutation_rate_end}{final mutation rate to be used when applying the X-Pauli gate, applied 
to each element of the chromosome (default is 1/(Genome+1))}

\item{mutation_flag}{flag indicating if the mutation gate is to be applied or not (default is TRUE)}

\item{plotting}{flag indicating plotting during iterations}

\item{verbose}{flag indicating printing fitness during iterations}

\item{progress}{flag indicating progress bar during iterations}

\item{eval_fitness}{name of the function that will be used to evaluate the fitness of each solution}

\item{eval_func_inputs}{specific inputs required by the eval_fitness function}

\item{stop_limit}{value to stop the iterations if the fitness is higher}
}
\value{
A numeric vector (positive integers) giving the best solution obtained by the QGA
}
\description{
Main function to execute a Quantum Genetic Algorithm
}
\details{
This function is the 'engine', which performs the quantum genetic algorithm calling
the function for the evaluation of the fitness that is specific for the particulare
problem to be optmized.
}
\examples{
\donttest{
#----------------------------------------
# Fitness evaluation for Knapsack Problem
#----------------------------------------
KnapsackProblem <- function(solution,
                            eval_func_inputs) {
  solution <- solution - 1
  items <- eval_func_inputs[[1]]
  maxweight <- eval_func_inputs[[2]]
  tot_items <- sum(solution)
  # Penalization
  if (sum(items$weight[solution]) > maxweight) {
    tot_items <- tot_items - (sum(items$weight[solution]) - maxweight)  
  }
  return(tot_items)
}
#----------------------------------------
# Prepare data for fitness evaluation
items <- as.data.frame(list(Item = paste0("item",c(1:300)),
                            weight = rep(NA,300)))
set.seed(1234)
items$weight <- rnorm(300,mean=50,sd=20)
hist(items$weight)
sum(items$weight)
maxweight = sum(items$weight) / 2
maxweight
#----------------------
# Perform optimization
popsize = 20
Genome = nrow(items)
solutionQGA <- QGA(popsize = 20,
                generation_max = 500,
                nvalues_sol = 2,
                Genome = nrow(items),
                thetainit = 3.1415926535 * 0.05,
                thetaend = 3.1415926535 * 0.025,
                pop_mutation_rate_init = 1/(popsize + 1),
                pop_mutation_rate_end = 1/(popsize + 1),
                mutation_rate_init = 1,
                mutation_rate_end = 1,
                mutation_flag = TRUE,
                plotting = TRUE,
                verbose = FALSE,
                progress = TRUE,
                eval_fitness = KnapsackProblem,
                eval_func_inputs = list(items,
                                        maxweight))
#----------------------
# Analyze results
solution <- solutionQGA[[1]]
solution <- solution - 1
sum(solution)
sum(items$weight[solution])
maxweight
}
}
