% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfit.R
\name{plotfit}
\alias{plotfit}
\title{S3 method for objects of class \code{R0.R} or \code{R0.sR}}
\usage{
plotfit(x, xscale = "w", SB.dist = TRUE, ...)
}
\arguments{
\item{x}{An output of \code{\link[=estimate.R]{estimate.R()}} (class \code{R0.sR}) or \code{est.R0.xx()} (class \code{R0.R}).}

\item{xscale}{Scale to be adjusted on x-axis. Can be \code{d} (day), \code{w} (week (default)), \code{f} (fornight), \code{m} (month).}

\item{SB.dist}{Boolean. Should the R distirbution throughout the epidemic be plotted for the SB method (defaults to \code{TRUE}) ?}

\item{...}{Parameters passed to inner functions.}
}
\value{
This function does not return any data.
}
\description{
This method ensures compliance with CRAN checks etc. It is used to properly
call \code{\link[=plotfit.R0.R]{plotfit.R0.R()}} and \code{\link[=plotfit.R0.sR]{plotfit.R0.sR()}} and build corresponding plots.
}
\details{
For internal use.

This method is designed to either call \code{\link[=plotfit.R0.R]{plotfit.R0.R()}} or \code{\link[=plotfit.R0.sR]{plotfit.R0.sR()}},
and complies with S3 requirements at the time of writing.

It allows plotting the goodness-of-fit of an estimated model to the
original epidemic curve provided the user.

Depending on the method of estimation, the graphical output will vary :
\itemize{
\item EG, ML and TD methods will show the original epidemic curve, along with the best-fitting prediction model,
\item AR will only show the epidemic curve, since no actual model is computed,
\item SB will display 9 density curves for the R distribution throughout the epidemic.
}
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
