% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_retirement_ruin.R
\name{calc_retirement_ruin}
\alias{calc_retirement_ruin}
\title{Calculating retirement ruin probability}
\usage{
calc_retirement_ruin(
  portfolio_return_mean,
  portfolio_return_sd,
  age,
  gompertz_mode,
  gompertz_dispersion,
  portfolio_value,
  monthly_spendings,
  yearly_spendings = 12 * monthly_spendings,
  spending_rate = yearly_spendings/portfolio_value
)
}
\arguments{
\item{portfolio_return_mean}{A numeric. Mean of portfolio returns.}

\item{portfolio_return_sd}{A numeric. Standard deviation of portfolio returns.}

\item{age}{A numeric. Current age.}

\item{gompertz_mode}{A numeric. Gompertz mode.}

\item{gompertz_dispersion}{A numeric. Gompertz dispersion.}

\item{portfolio_value}{A numeric. Initial portfolio value.}

\item{monthly_spendings}{A numeric. Monthly spendings.}

\item{yearly_spendings}{A numeric. Yearly spendings.}

\item{spending_rate}{A numeric. Spending rate
(initial withdrawal rate).}
}
\value{
A numeric. The probability of retirement ruin (between 0 and 1),
representing the likelihood of running out of money during retirement.
}
\description{
Calculating retirement ruin probability
}
\examples{
calc_retirement_ruin(
  age                   = 65,
  gompertz_mode         = 88,
  gompertz_dispersion   = 10,
  portfolio_value       = 1000000,
  monthly_spendings     = 3000,  
  portfolio_return_mean = 0.02,
  portfolio_return_sd   = 0.15
)
}
\references{
Milevsky, M.A. (2020). Retirement Income Recipes in R: From Ruin Probabilities to Intelligent Drawdowns. Use R! Series. \doi{10.1007/978-3-030-51434-1}.
}
