% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_ransac.R
\name{metrics_ransac}
\alias{metrics_ransac}
\title{Performance Metrics for RANSAC Models}
\usage{
metrics_ransac(model, data)
}
\arguments{
\item{model}{A model fitted via RANSAC (`ransac_model` or `ransac_nls`).}

\item{data}{Data frame containing the model variables.}
}
\value{
A data frame with RMSE, MAE, and R² calculated on the inliers.
}
\description{
Calculates the root mean square error (RMSE), mean absolute error (MAE), and coefficient of determination (R²)
for a model fitted using the RANSAC algorithm.
}
\examples{
set.seed(123)
D <- seq(10, 50, by = 5)
H <- seq(15, 30, length.out = length(D))
V <- 0.01 * D^2 * H + rnorm(length(D), sd = 5)
V[c(3, 7)] <- V[c(3, 7)] + 50  # add outliers
data <- data.frame(D = D, H = H, V = V)

model <- ransac_nls(V ~ a * D^b * H^c, data = data,
                    start = list(a = 0.01, b = 2, c = 1),
                    n_min = 4, n_iter = 100, tol = 10)

metrics_ransac(model, data)

}
