% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RAQSAPIlistfunctions.R
\name{aqs_sampledurations}
\alias{aqs_sampledurations}
\title{aqs_sampledurations}
\usage{
aqs_sampledurations(return_header = FALSE)
}
\arguments{
\item{return_header}{If FALSE (default) only returns data requested.
If TRUE returns a AQSAPI_v2 object which is a two
item list that contains header information returned
from the API server mostly used for debugging
purposes in addition to the data requested.}
}
\value{
a tibble or an AQS_Data Mart_APIv2 S3 object of sample durations and
their associated duration codes
(groups of parameters, i.e. "criteria" or "all").
}
\description{
\lifecycle{stable}
Returns a table of sample durations and their
associated duration codes. Returned values are not calculated
durations such as 8 hour CO or O$_3$ rolling averages, 3/6
day PM averages or Pb 3 month rolling averages.
}
\note{
Not all sample durations that are available through AQS are available
through the AQS Data Mart API, including certain calculated sample
durations. Only sample durations that are available through the
AQS Data Mart API are returned.
}
\examples{
# Returns a tibble or an AQS_Data Mart_APIv2 S3 object of
         \dontrun{ aqs_sampledurations() }
}
