% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSAPI_helperfunctions.R
\name{aqs_services_by_site}
\alias{aqs_services_by_site}
\title{aqs_services_by_site}
\usage{
aqs_services_by_site(
  parameter,
  bdate,
  edate,
  stateFIPS,
  countycode,
  sitenum,
  duration = NA_character_,
  service,
  cbdate = NA_Date_,
  cedate = NA_Date_,
  AQS_domain = "aqs.epa.gov"
)
}
\arguments{
\item{parameter}{a character list or a single character string
which represents the parameter code of the air
pollutant related to the data being requested.}

\item{bdate}{a R date object which represents that begin date of the data
selection. Only data on or after this date will be returned.}

\item{edate}{a R date object which represents that end date of the data
selection. Only data on or before this date will be returned.}

\item{stateFIPS}{a R character object which represents the 2 digit state
FIPS code (with leading zero) for the state being
requested. @seealso \code{\link[=aqs_states]{aqs_states()}} for the list of
available FIPS codes.}

\item{countycode}{a R character object which represents the 3 digit state
FIPS code for the county being requested (with leading
zero(s)). @seealso \code{\link[=aqs_counties_by_state]{aqs_counties_by_state()}} for the
list of available county codes for each state.}

\item{sitenum}{a R character object which represents the 4 digit site number
(with leading zeros) within the county and state being
requested.}

\item{duration}{an optional R character string that represents the
parameter duration code that limits returned data
to a specific sample duration. The default value of
NA_character_ results in no filtering based on
duration code.Valid durations include actual sample
durations and not calculated durations such as 8
hour CO or $O_3$ rolling averages, 3/6 day PM
averages or Pb 3 month rolling averages.
@seealso \code{\link[=aqs_sampledurations]{aqs_sampledurations()}} for a list of all
available duration codes.}

\item{service}{a string which represents the services provided by the AQS
API. For a list of available services @seealso
\url{https://aqs.epa.gov/aqsweb/documents/data_api.html#services}}

\item{cbdate}{a R date object which represents a "beginning
date of last change" that indicates when the data was last
updated. cbdate is used to filter data based on the change
date. Only data that changed on or after this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{cedate}{a R date object which represents an "end
date of last change" that indicates when the data was last
updated. cedate is used to filter data based on the change
date. Only data that changed on or before this date will be
returned. This is an optional variable which defaults
to NA_Date_.}

\item{AQS_domain}{a R string object containing the domain that should be
used in constructing the API call.}
}
\value{
a AQS_DATAMART_APIv2 S3 object that is the return value from the
AQS API. A AQS_DATAMART_APIv2 is a 2 item named list in which the
first item ($Header) is a tibble of header information from the
AQS API and the second item ($Data) is a tibble of the data
returned.
}
\description{
a helper function that abstracts the formatting of the inputs
for a call to aqs away from the calling function for
aggregations by site then calls the aqs and returns the
result. This helper function is not meant to be called
directly from external functions.
}
\seealso{
Other Aggregate _by_site functions: 
\code{\link{aqs_annualsummary_by_site}()},
\code{\link{aqs_dailysummary_by_site}()},
\code{\link{aqs_monitors_by_site}()},
\code{\link{aqs_qa_annualperformanceeval_by_site}()},
\code{\link{aqs_qa_annualperformanceevaltransaction_by_county}()},
\code{\link{aqs_qa_annualperformanceevaltransaction_by_site}()},
\code{\link{aqs_qa_blanks_by_site}()},
\code{\link{aqs_qa_collocated_assessments_by_site}()},
\code{\link{aqs_qa_flowrateaudit_by_site}()},
\code{\link{aqs_qa_flowrateverification_by_site}()},
\code{\link{aqs_qa_one_point_qc_by_site}()},
\code{\link{aqs_qa_pep_audit_by_site}()},
\code{\link{aqs_sampledata_by_site}()},
\code{\link{aqs_transactionsample_by_site}()}
}
\concept{Aggregate _by_site functions}
