% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBCD_BINARY.R
\name{DBCD_BINARY}
\alias{DBCD_BINARY}
\title{Doubly Adaptive Biased Coin Design (Binary Responses)}
\usage{
DBCD_BINARY(S_RK, N_RK, group_allo, rho_func_index, rho_func, alpha)
}
\arguments{
\item{S_RK}{A vector of current success rates for each treatment arm.}

\item{N_RK}{A vector of current enrolled subjects in each arm. The length
must be the same as `S_RK`.}

\item{group_allo}{An integer of the size of group allocation. The default is
1.}

\item{rho_func_index}{Supply a number of 1, 2 or 3 indicting the
allocation function to use.
1 = Wei's allocation;
2 = Neyman allocation;
3 = Rosenberger allocation.
The default is 3.}

\item{rho_func}{Supply a user-specified allocation function of S_RK when
rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}
}
\value{
Number of the arm that the next subject is assigned to.
}
\description{
Allocates patients to one of treatments based on doubly adaptive
biased coin design on summary level data.
}
\details{
'DBCD_BINARY' assigns the next subject to a group given the observed
success rates, enrolled subjects and allocation function.
}
\examples{
# There are 3 arms each of which receives 25 patients.
# The observed response rates are 40\%, 28\% and 60\%, respectively.
# The following command returns the number of arm that the next patient will
# be assigned to.
DBCD_BINARY(S_RK = c(0.4, 0.28, 0.6),
            N_RK = c(25, 25, 25),
            rho_func_index = 3, alpha=2)

# Urn allocation
DBCD_BINARY(S_RK = c(0.4, 0.3),
            N_RK = c(25, 25),
            group_allo = 1,
            rho_func_index = NULL,
            rho_func = function(x) rev(1-x)/sum(1-x),
            alpha=2)

}
