% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_factor.R
\name{rd_factor}
\alias{rd_factor}
\title{Convert Variables to Factors in a REDCap Dataset}
\usage{
rd_factor(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  exclude = NULL
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{exclude}{Optional character vector of variable names (use original names \strong{without} the \code{.factor} suffix) to exclude from conversion.}
}
\value{
A list with the following elements:
\describe{
\item{data}{The transformed dataset with \code{.factor} columns applied as factors.}
\item{dictionary}{The dictionary used (unchanged).}
\item{event_form}{The event-form mapping used (if applicable).}
\item{results}{A brief text summary of the transformation.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Converts variables in a REDCap dataset with associated \code{.factor} columns into actual factor variables, while allowing the exclusion of specific variables. Ensures consistency with the dataset and preserves variable labels.
}
\details{
The function looks for columns ending in \code{.factor} and replaces the original variable values with those \code{.factor} values (converted to factors). It preserves variable labels. The \code{exclude} argument must contain base variable names (no \code{.factor} suffix); if any \code{.factor} names are passed to \code{exclude} the function will throw an informative error. The columns \code{redcap_event_name}, \code{redcap_repeat_instrument} and \code{redcap_data_access_group} (and their \code{.factor} counterparts) are handled specially to avoid altering event or access-group data.
}
\examples{
\dontrun{
result <- rd_factor(covican)
result <- rd_factor(covican, exclude = c("available_analytics", "urine_culture"))
transformed_data <- result$data
}

}
