% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieveBest.R
\name{extract}
\alias{extract}
\title{extract remix results from cvRemix object}
\usage{
extract(fit, n)
}
\arguments{
\item{fit}{output of \code{\link{cv.remix}};}

\item{n}{rank (in the `fit$lambda`) to extract.}
}
\value{
outputs from \code{\link{remix}} algorithm of rank `n` computed by \code{\link{cv.remix}}.
}
\description{
Extracts a build from a cvRemix object.
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)

cv.outputs = cv.Remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            ncores=8,
            eps2=1)

res <- extract(cv.outputs,6)

plotConvergence(res)

trueValue = read.csv(paste0(dirname(project),"/demoSMLX/Simulation/populationParameters.txt"))


plotSAEM(res,paramToPlot = c("delta_S_pop","phi_S_pop","delta_AB_pop"),trueValue=trueValue)
}
}
\seealso{
\code{\link{cv.remix}}, \code{\link{remix}}.
}
