% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_price_index.R
\name{calculate_price_index}
\alias{calculate_price_index}
\title{Calculate index based on specified method (Fisher, Laspeyres, Paasche, HMTS, Time Dummy, Rolling Time Dummy)}
\usage{
calculate_price_index(
  dataset,
  method,
  period_variable,
  dependent_variable,
  numerical_variables = NULL,
  categorical_variables = NULL,
  reference_period = NULL,
  number_of_observations = TRUE,
  periods_in_year = 4,
  production_since = NULL,
  number_preliminary_periods = 3,
  resting_points = FALSE,
  imputation = FALSE,
  window_length = 5
)
}
\arguments{
\item{dataset}{Data frame with input data}

\item{method}{One of: "fisher", "laspeyres", "paasche", "hmts", "timedummy", "rolling_timedummy", "repricing"}

\item{period_variable}{A string with the name of the column containing time periods. Values must follow a consistent format such as "2020Q1" (quarterly), "2020M01" (monthly), "202001" (YYYYMM), "2020W01" (weekly), or "2020" (yearly). Mixed or irregular formats (e.g., "Q1_2020", "Jan2020") are not supported.}

\item{dependent_variable}{Usually the price}

\item{numerical_variables}{Vector with numeric quality-determining variables}

\item{categorical_variables}{Vector with categorical variables (also dummies)}

\item{reference_period}{Period or group of periods that will be set to 100}

\item{number_of_observations}{Logical, whether to show number of observations (default = TRUE)}

\item{periods_in_year}{(HMTS only) Number of periods per year (e.g. 12 for months)}

\item{production_since}{(HMTS only) Start period for production simulation}

\item{number_preliminary_periods}{(HMTS only) Number of preliminary periods}

\item{resting_points}{(HMTS only) Whether to return detailed outputs (default = FALSE)}

\item{imputation}{(Laspeyres/Paasche only) Include imputation values? Default = FALSE}

\item{window_length}{(Rolling Time Dummy only) Window size in number of periods}
}
\value{
A data.frame (or list for HMTS with resting_points = TRUE; or named list if multiple methods are used)
}
\description{
Central hub function to calculate index figures using different methods.
}
\examples{
# Example: Time Dummy index
Tbl_TD <- calculate_price_index(
  method = "timedummy",
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = "floor_area",
  categorical_variables = "neighbourhood_code",
  reference_period = "2015",
  number_of_observations = FALSE
)
head(Tbl_TD)

# Example: Multiple methods (Fisher, Paasche, Laspeyres)
multi_result <- calculate_price_index(
  method = c("fisher", "paasche", "laspeyres"),
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = "floor_area",
  categorical_variables = "neighbourhood_code",
  reference_period = "2015",
  number_of_observations = FALSE
)

head(multi_result$fisher)
head(multi_result$paasche)
head(multi_result$laspeyres)
}
\author{
Vivek Gajadhar
}
