% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_rolling_timedummy.R
\name{calculate_rolling_timedummy}
\alias{calculate_rolling_timedummy}
\title{Calculate Rolling Time Dummy Index}
\usage{
calculate_rolling_timedummy(
  dataset,
  period_variable,
  dependent_variable,
  numerical_variables,
  categorical_variables,
  reference_period,
  window_length,
  number_of_observations = FALSE
)
}
\arguments{
\item{dataset}{data frame with input data}

\item{period_variable}{name of the time variable (string)}

\item{dependent_variable}{name of the dependent variable (usually price, assumed unlogged)}

\item{numerical_variables}{vector of numeric quality-determining variables}

\item{categorical_variables}{vector of categorical variables}

\item{reference_period}{period to be normalized to index = 100 (e.g., "2015")}

\item{window_length}{length of each rolling window (integer)}

\item{number_of_observations}{logical, whether to return number of observations per period (default = FALSE)}
}
\value{
data frame with period, Index, and optionally number_of_observations
}
\description{
Estimates a price index using rolling windows of time dummy regressions.
}
\author{
Vivek Gajadhar
}
\keyword{internal}
