% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_table.R
\name{fetch_table}
\alias{fetch_table}
\title{Fetch Exoplanets table}
\usage{
fetch_table(
  table,
  query_string = NULL,
  pretty_colnames = FALSE,
  format = "csv"
)
}
\arguments{
\item{table}{A string specifying the table to query. Must be one of:
\itemize{
\item \code{ps} - Planetary Systems table
\item \code{pscomppars} – Planetary Systems Composite Parameters table
\item \code{stellarhosts} – Stellar Hosts table
\item \code{keplernames} – Kepler Confirmed Names
}}

\item{query_string}{Optional ADQL \code{WHERE} clause as a string, e.g., \verb{pl_bmasse > 1 AND st_teff < 6000}.}

\item{pretty_colnames}{Optional \code{bool} value. If \code{TRUE} replaces database column names with their
labels / descriptions. Defaults to \code{FALSE}.
Currently only tables \code{ps} and \code{pscomppars} are supported.}

\item{format}{Optional \code{char} value specifying output format. Can be either \code{"csv"} for data frame,
or \code{"json"} for a named list.}
}
\value{
A data frame or named list containing fetched data.
}
\description{
Fetch Exoplanets table
}
\details{
Fetches data from an exoplanets TAP (Table Access Protocol) service
and returns it as a data frame or a named list.
You can optionally specify \code{WHERE} ADQL clause to filter rows based on conditions.
}
\examples{
\donttest{
 # All entries from Stellar Hosts table
 fetch_table("stellarhosts")
 # Entries from Planetary Systems table where planetary mass > 3 times the earth mass
 fetch_table("ps", query_string = "pl_bmasse > 3")
 # Planets orbiting Teegarden's Star with radius > 1 Earth radius
 fetch_table("pscomppars", query_string = "hostname = 'Teegarden''s Star' and pl_rade > 1")
}

}
