% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfp.R
\name{TFPmodel}
\alias{TFPmodel}
\title{TFP trend model}
\usage{
TFPmodel(
  tsl,
  trend = "DT",
  cycle = "AR2",
  cycleLag = 0,
  cubsAR = 0,
  cubsErrorARMA = c(0, 0),
  start = NULL,
  end = NULL,
  anchor = NULL,
  anchor.h = NULL
)
}
\arguments{
\item{tsl}{A list of time series objects, see details.}

\item{trend}{A character string specifying the trend model. \code{trend = "RW1"} denotes
a first order random walk, \code{trend = "RW2"} a second order random walk (local linear
trend) and \code{trend = "DT"} a damped trend model. The default is \code{trend = "DT"}.}

\item{cycle}{A character string specifying the cycle model. \code{cycle = "AR1"} denotes
an AR(1) process, \code{cycle = "AR2"} an AR(2) process, \code{cycle = "RAR2"} a
reparametrized AR(2) process. The default is \code{cycle = "AR2"}.}

\item{cycleLag}{A non-negative integer specifying the maximum cycle lag that is included
in the CUBD equation. The default is \code{cycleLag = 0}, see details.}

\item{cubsAR}{A non-negative integer specifying the maximum CUBS lag that is included
in the CUBS equation. The default is \code{cubsAR = 0}, see details.}

\item{cubsErrorARMA}{A vector with non-negative integers specifying the AR
and MA degree of the error term in the CUBS equation. The default is
\code{cubsErrorARMA = c(0, 0)}, see details.}

\item{start}{(Optional) Start vector for the estimation, e.g. \code{c(1980, 1)}.}

\item{end}{(Optional) End vector for the estimation, e.g. \code{c(2020, 1)}.}

\item{anchor}{(Optional) Snchor value for the log of the TFP trend.}

\item{anchor.h}{(Optional) Anchor horizon in the frequency of the given time series.}
}
\value{
Object of class TFPmodel, which is a list with the following components:
  \item{tsl}{A list of used time series.}
  \item{SSModel}{An object of class SSModel specifying the state-space model.}
  \item{loc}{A data frame containing information on each involved parameter, for instance
        its corresponding system matrix, variable names, and parameter restrictions.}
  \item{call}{Original call to the function. }
  In addition, the object contains the following attributes:
  \item{cycle}{Cycle specification.}
  \item{trend}{Trend specification.}
  \item{cubs}{A list containing the components \code{cycleLag, cubsAR, errorARMA, exoVariables}.}
  \item{anchor}{A list containing the components \code{value, horizon}.}
  \item{period}{A list containing the components \code{start, end, frequency}.}
}
\description{
Creates a state space object object of class \code{TFPmodel} which can be 
  fitted using \code{fit}.
}
\details{
The list of time series \code{tsl} needs to have the following components:
\describe{
    \item{tfp}{Total factor productivity.}
    \item{cubs}{Capacity utilization economic sentiment indicator.}
    }

A \code{cycleLag} equal to \code{0} implies that only the contemporaneous cycle
  is included in the CUBS equation.  A \code{cycleLag} equal to \code{0:1} implies that
  the contemporaneous as well as the lagged cycle are included.

A \code{cubsAR} equal to \code{0} implies that no autoregressive term is
  included in the CUBS equation.  \code{cubsAR = 1} implies that a lagged term is
  included, \code{cubsAR = 2} implies that a two lags are included, and so on.

A \code{cubsErrorARMA} equal to \code{c(0, 0)} implies that the error term in the
  CUBS equation is white noise. \code{cubsErrorARMA = c(1, 0)} implies that the error is
  an AR(1) process and for \code{cubsErrorARMA = c(1, 2)} the error follows an ARMA(1, 2)
  process.
}
\examples{
# load data for Germany
data("gap")
data("indicator")
country <- "Germany"
tsList <- amecoData2input(gap[[country]], alpha = 0.65)

# compute cubs indicator
namesCubs <- c("indu", "serv", "buil")
namesVACubs <- paste0("va", namesCubs)
tscubs <- cubs(
  tsCU = gap[[country]][, namesCubs],
  tsVA = gap[[country]][, namesVACubs]
)
tsList <- c(tsList, tscubs)

# define tfp model
model <- TFPmodel(tsl = tsList, cycle = "RAR2", cubsErrorARMA = c(1,0))
}
