% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfp_mle.R
\name{.MLEfitTFP}
\alias{.MLEfitTFP}
\title{Estimates a two-dimensional state-space model and performs filtering and smoothing
to obtain the tfp trend.}
\usage{
.MLEfitTFP(
  model,
  parRestr = initializeRestr(model),
  signalToNoise = NULL,
  control = NULL
)
}
\arguments{
\item{model}{An object of class TFPmodel.}

\item{parRestr}{A list of matrices containing the parameter restrictions for the cycle,
trend, and the CUBS equation. Each matrix contains the lower and upper bound of the
involved parameters. \code{NA} implies that no restriction is present. Autoregressive
parameters are automatically restricted to the stationary region unless box constraints
are specified. By default, \code{parRestr} is initialized by the function
\code{initializeRestr(model)}. Only used if \code{method = "MLE"}.}

\item{signalToNoise}{(Optional) signal to noise ratio. Only used if \code{method = "MLE"}.}

\item{control}{(Optional) A list of control arguments to be passed on to \code{optim}.}
}
\description{
Estimates a two-dimensional state-space model and performs filtering and smoothing
to obtain the tfp trend.
}
\keyword{internal}
