% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nawru.R
\name{fit.NAWRUmodel}
\alias{fit.NAWRUmodel}
\title{Estimation of a \code{NAWRUmodel}}
\usage{
\method{fit}{NAWRUmodel}(
  model,
  parRestr = initializeRestr(model = model),
  signalToNoise = NULL,
  method = "MLE",
  control = NULL,
  prior = initializePrior(model),
  R = 10000,
  burnin = ceiling(R/10),
  thin = 1,
  HPDIprob = 0.85,
  pointEstimate = "mean",
  MLEfit = NULL,
  ...
)
}
\arguments{
\item{model}{An object of class NAWRUmodel.}

\item{parRestr}{A list of matrices containing the parameter restrictions for the cycle,
trend, and the Phillip's curve. Each matrix contains the lower and upper bound of the
involved parameters. \code{NA} implies that no restriction is present. Autoregressive
parameters are automatically restricted to the stationary region unless box constraints
are specified. By default, \code{parRestr} is initialized by the function
\code{initializeRestr(model)}. Only used if \code{method = "MLE"}.}

\item{signalToNoise}{(Optional) signal to noise ratio. Only used if \code{method = "MLE"}.}

\item{method}{The estimation method. Options are maximum likelihood estimation \code{"MLE"}
and bayesian estimation \code{"bayesian"}. The default is \code{method = "MLE"}.}

\item{control}{(Optional) A list of control arguments to be passed on to \code{optim}.}

\item{prior}{A list of matrices with parameters for the prior distribution and box
constraints. By default, \code{prior} is initialized by \code{initializePrior(model)}.
See details. Only used if \code{method = "bayesian"}.}

\item{R}{An integer specifying the number of MCMC draws. The default is \code{R = 10000}.
Only used if \code{method = "bayesian"}.}

\item{burnin}{An integer specifying the burn-in phase of the MCMC chain. The default is
\code{burnin = ceiling(R / 10)}. Only used if \code{method = "bayesian"}.}

\item{thin}{An integer specifying the thinning interval between consecutive draws. The
default is \code{thin = 1}, implying that no draws are dopped. For \code{thin = 2},
every second draw is dropped and so on. Only used if \code{method = "bayesian"}.}

\item{HPDIprob}{A numeric in the interval \code{(0,1)} specifying the target probability
of the highest posterior density intervals. The default is \code{HPDIprob = 0.9}. Only
used if \code{method = "bayesian"}.}

\item{pointEstimate}{Posterior distribution's statistic of central tendency. Possible
options are \code{"mean"} and \code{"median"}. The default is \code{pointEstimate = "mean"}.
Only used if \code{method = "bayesian"}.}

\item{MLEfit}{(Optional) An object of class \code{NAWRUfit} which is used for
initialization. Only used if \code{method = "bayesian"}.}

\item{...}{additional arguments to be passed to the methods functions.}
}
\value{
For maximum likelihood estimation, an object of class \code{NAWRUfit} containing
  the following components:
  \item{model}{The input object of class \code{NAWRUmodel}.}
  \item{SSMfit}{The estimation output from the function \code{fitSSM} from \code{KFAS}.}
  \item{SSMout}{The filtering and smoothing output from the function \code{KFS} from
        \code{KFAS}.}
  \item{parameters}{A data frame containing the estimated parameters, including standard
        errors, t-statistics, and p-values.}
  \item{parRestr}{A list of matrices containing the enforced parameter constraints.}
  \item{fit}{A list of model fit criteria (see below).}
  \item{call}{Original call to the function. }
  The list component \code{fit} contains the following model fit criteria:
  \item{loglik}{Log-likelihood function values.}
  \item{AIC}{Akaike information criterion.}
  \item{BIC}{Bayesian information criterion.}
  \item{AIC}{Hannan-Quinn information criterion.}
  \item{RMSE}{root mean squared error of the Phillip's curve equation.}
  \item{R2}{R squared of the Phillip's curve equation.}
  \item{LjungBox}{Ljung-Box test output of the Phillip's curve equation.}
  \item{signal-to-noise}{Signal-to-noise ratio.}
For bayesian estimation, an object of class \code{NAWRUfit} containing the following
  components:
  \item{model}{The input object of class \code{NAWRUmodel}.}
  \item{tsl}{A list of time series containing the estimated states.}
  \item{parameters}{A data frame containing the estimated parameters, including standard
        errors, highest posterior density credible sets.}
  \item{prior}{A list of matrices containing the used prior distributions.}
  \item{fit}{A list of model fit criteria (see below).}
  \item{call}{Original call to the function. }
  The list component \code{fit} contains the following model fit criteria:
  \item{R2}{R squared of the phillips curve equation,}
  \item{signal-to-noise}{Signal-to-noise ratio.}
}
\description{
Estimates a two-dimensional state-space model and performs filtering and
  smoothing to obtain the NAWRU using either maximum likelihood estimation or bayesian
  methods.
}
\details{
The list object \code{prior} contains three list elements \code{cycle},
  \code{trend}, and \code{pcInd}. Each list element is a \code{4 x n} matrix where \code{n}
  denotes the number of parameters involved in the respective equation. The upper two
  elements specify the distribution, the lower two parameters specify box constraints.
  \code{NA} denotes no constraints. Autoregressive parameters are automatically restricted
  to the stationary region unless box constraints are specified. For instance,
  \code{prior$cycle[, 1]} contains the mean, standard deviation, lower and upper bound for
  the first variable, in that respective order.

The respective prior distributions are defined through their mean and standard
  deviation.

The Gibbs sampling procedure is as follows. For each \eqn{r = 1, ..., R}
  \itemize{\item The states are sampled by running the Kalman filter and smoother
           conditional on the parameters of the previous step, \eqn{\theta_{r-1}}
           \item Trend equation parameters \eqn{\theta_{trend}}: Conditional on the
           states \eqn{\alpha_r}, a draw \eqn{\theta_{trend,k}} is obtained either
           by a sequential Gibbs step, a Metropolis Hasting step, or by conjugacy,
           depending on the trend model specification.
           \item Cycle equation parameters \eqn{\theta_{cycle}}: Conditional on the
           states \eqn{\alpha_r}, a draw \eqn{\theta_{cycle,k}} is obtained either
           by a sequential Gibbs step, a Metropolis Hasting step, or by conjugacy,
           depending on the cycle model specification.
           \item Phillip's curve equation parameters \eqn{\theta_{pcInd}}: Conditional on the
           states \eqn{\alpha_r}, a draw \eqn{\theta_{pcInd,k}} is obtained either
           by a sequential Gibbs step, a Metropolis Hasting step, a combination
           thereof, or by conjugacy, depending on the Phillip's curve equation specification.}
}
\examples{
# define nawru model for France
data("gap")
country <- "France"
tsList <- amecoData2input(gap[[country]])
model <- NAWRUmodel(tsl = tsList)
# estimate nawru model via MLE
parRestr <- initializeRestr(model = model, type = "hp")
\donttest{
f <- fit(model = model, parRestr = parRestr)
}
# initialize priors and estimate model via Bayesian methods
prior <- initializePrior(model = model)
\donttest{
f <- fit(model = model, method = "bayesian", prior = prior, R = 5000, thin = 2)
}
}
\seealso{
Other fitting methods: 
\code{\link{fit.KuttnerModel}()},
\code{\link{fit.TFPmodel}()},
\code{\link{fit}()}
}
\concept{fitting methods}
