% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StationaryFrequencyAnalysis.R
\name{EstimatePSDSlope}
\alias{EstimatePSDSlope}
\title{Estimate the slope of the Power Spectral Density (PSD).}
\usage{
EstimatePSDSlope(
  HRVData,
  indexFreqAnalysis = length(HRVData$FreqAnalysis),
  indexNonLinearAnalysis = length(HRVData$NonLinearAnalysis),
  regressionRange = NULL,
  doPlot = T,
  main = "PSD power law",
  xlab = "Frequency (Hz)",
  ylab = "Spectrum",
  pch = NULL,
  log = "xy",
  ...
)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it.}

\item{indexFreqAnalysis}{An integer referencing the periodogram that will be
used for estimating the spectral index.}

\item{indexNonLinearAnalysis}{An integer referencing the structure that will
store the resulting estimations.}

\item{regressionRange}{Range of frequencies in which the regression will be
performed. Default is c(1e-4, 1e-2) Hz.}

\item{doPlot}{Plot the periodogram and the least-squares fit?}

\item{main}{Title for the plot.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{pch}{Symbol for the plotting points.}

\item{log}{A character string which contains "x" if the x axis is to be 
logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if 
both axes are to be logarithmic (default).}

\item{...}{Other arguments for the plotting function.}
}
\value{
The \emph{EstimatePSDSlope} returns the \emph{HRVData} structure 
containing a \emph{PSDSlope} field storing the spectral index and the 
proper Hurst exponent.
}
\description{
Estimate the slope of the Power Spectral Density (PSD)  of the 
RR time series.
}
\details{
The power spectrum of most physiological signals fulfils
\eqn{S(f)=Cf^{-\beta}}{S(f)=C*f^-B} (1/f spectrum). This function estimates
the \eqn{\beta}{B} exponent, which is usually referred to as the spectral
index.
}
\note{
It should be noted that the PSD must be estimated prior to the
use of this function. We do not recommend the use of the AR spectrum when
estimating the spectral index.
}
\examples{
\dontrun{
data(HRVProcessedData)
# use other name for convenience
HRVData=HRVProcessedData
# Estimate the periodogram
HRVData=CreateFreqAnalysis(HRVData)
HRVData=CalculatePSD(HRVData,1,"pgram",doPlot = T,log="xy")
HRVData=CreateNonLinearAnalysis(HRVData)
HRVData=SetVerbose(HRVData,T)
HRVData=EstimatePSDSlope(HRVData,1,1,
                        regressionRange=c(5e-4,1e-2))
}
}
\references{
Voss, Andreas, et al. "Methods derived from nonlinear dynamics 
for analysing heart rate variability." Philosophical Transactions of the 
Royal Society A: Mathematical, Physical and Engineering Sciences 367.1887 
(2009): 277-296.

Eke, A., Herman, P., Kocsis, L., & Kozak, L. R. (2002). Fractal 
characterization of complexity in temporal physiological signals. 
Physiological measurement, 23(1), R1.
}
\seealso{
\code{\link[stats]{spectrum}},\code{\link[lomb]{lsp}},
 \code{\link[RHRV]{CalculatePSD}}.
}
