% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractTimeSegment.R
\name{ExtractTimeSegment}
\alias{ExtractTimeSegment}
\title{Time windows of HR record}
\usage{
ExtractTimeSegment(HRVData, starttime, endtime)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and information 
related to it. This function calls \emph{Window} to perform the extraction.}

\item{starttime}{The start time of the period of interest.}

\item{endtime}{The end time of the period of interest.}
}
\value{
A new \emph{HRVData} structure containing the temporal data  
within the specified range.
}
\description{
Extracts a temporal subset between the times starttime and endtime.
}
\details{
If the \emph{HRVData} contains episodes, beats or RR time series,
these will be also extracted into the new HRV structure. On the other hand,
all the analysis stored in the original structure will be lost.
}
\examples{
\dontrun{
data(HRVProcessedData)
# Rename for convenience
HRVData <- HRVProcessedData
PlotNIHR(HRVData)
newHRVData <- ExtractTimeSegment(HRVData,2000,4000)
PlotNIHR(newHRVData)
}
}
\author{
Leandro Rodriguez-Linares
}
