#' @title find_linear_peptides_parallel
#' @description  this is a non-exportable function, the goal of this function is
#' to check for linear peptides among the high-ALC unassigned  spectra from the
#' denovo results.(parallel version)
#' @param input_for_HF peptide sequence, output of the "prepare_input_for_HF"
#' function.
#' @param proteome_db proteome database
#' @return list of the peptides that are linear peptides
#' @details this is a non-exportable function, that takes in as input the unique
#' peptide sequences generated by "prepare_input_for_HF" and the proteome database
#' to search into and returns a list of all denovo linear peptides with parallel
#' computing
#' @noRd
#' @keywords internal

find_linear_peptides_parallel<- function(input_for_HF, proteome_db){
  linear_peptides <- grep(paste0("(",input_for_HF,")"), proteome_db, perl=TRUE)
  return(linear_peptides)
}
