% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfCreateCorCbmDataset.R
\name{DfCreateCorCbmDataset}
\alias{DfCreateCorCbmDataset}
\title{Create paired dataset for testing \code{\link{FitCorCbm}}}
\usage{
DfCreateCorCbmDataset(
  seed = 123,
  K1 = 50,
  K2 = 50,
  desiredNumBins = 5,
  muX = 1.5,
  muY = 3,
  alphaX = 0.4,
  alphaY = 0.7,
  rhoNor = 0.3,
  rhoAbn2 = 0.8
)
}
\arguments{
\item{seed}{The seed variable, default is 123; set to NULL for truly random seed}

\item{K1}{The number of non-diseased cases, default is 50}

\item{K2}{The number of diseased cases, default is 50}

\item{desiredNumBins}{The desired number of bins; default is 5}

\item{muX}{The CBM \eqn{\mu} parameter in condition X}

\item{muY}{The CBM \eqn{\mu} parameter in condition Y}

\item{alphaX}{The CBM \eqn{\alpha} parameter in condition X}

\item{alphaY}{The CBM \samp{alpha} parameter in condition Y}

\item{rhoNor}{The correlation of non-diseased case z-samples}

\item{rhoAbn2}{The correlation of diseased case z-samples, when disease is
visible in both conditions}
}
\value{
The return value is the desired dataset, suitable for testing \code{\link{FitCorCbm}}.
}
\description{
The paired dataset is generated using bivariate sampling; 
details are in referenced publication
}
\details{
The ROC data is bined to 5 bins in each condition.
}
\examples{
## seed <- 1 
## this gives unequal numbers of bins in X and Y conditions for 50/50 dataset
dataset <- DfCreateCorCbmDataset()

\donttest{
## this takes very long time!! used to show asymptotic convergence of ML estimates 
## dataset <- DfCreateCorCbmDataset(K1 = 5000, K2 = 5000)
}


}
\references{
Zhai X, Chakraborty DP (2017) A bivariate contaminated binormal model for robust fitting of proper ROC
curves to a pair of correlated, possibly degenerate, ROC datasets. Medical Physics. 44(6):2207--2222.
}
