% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RME_erdos}
\alias{RME_erdos}
\title{Generate an ensemble of Erdos-Renyi transition matrices}
\usage{
RME_erdos(N, p, size)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{p}{the probability two vertices are connected in an Erdos-Renyi graph.}

\item{size}{the size of the ensemble (i.e. number of matrices)}
}
\value{
An ensemble (list) of Erdos-Renyi transition matrices as specified by the matrix arguments.
}
\description{
Given the same arguments as RM_norm, this function returns an ensemble of random Erdos-Renyi stochastic matrices.
  While random matrices usually do not exude unique properties on their own, they do indeed have
  deterministic properties at the ensemble level in terms of their spectral statistics.
}
\examples{
# Generate an ensemble of 10x10 Erdos-Renyi transition matrices of size 50 with p = 0.7
ensemble <- RME_erdos(N = 10, p = 0.7, size = 50)

}
