% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RM_unif}
\alias{RM_unif}
\title{Generate a uniform random matrix}
\usage{
RM_unif(N, min, max, symm = FALSE, cplx = FALSE, herm = FALSE)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{min}{minimum of the uniform distribution to be sampled from}

\item{max}{maximum of the uniform distribution to be sampled from}

\item{symm}{indicates whether the matrix should be symmetric (equal to its transpose).}

\item{cplx}{indicates whether the matrix should have complex entries.}

\item{herm}{indicates whether the matrix should be hermitian (equal to its conjugate transpose).
Reserved for when cplx = TRUE, otherwise use symm = TRUE.}
}
\value{
A random matrix with uniformly distributed entries.
}
\description{
Uniform random matrices are matrices with uniformly distributed entries. They are an elementary type of random matrix.
}
\examples{
# Unif(1,2) distributed matrix
P <- RM_unif(N = 3, min = 1, max = 2)

# Unif(0,5) distributed matrix with real symmetric entries
P <- RM_unif(N = 7, min = 0, max = 5, symm = TRUE)

# Unif(0,1) distributed matrix with complex entries
Q <- RM_unif(N = 7, min = 0, max = 1, cplx = TRUE)

# Unif(2,10) distributed matrix with hermitian complex entries
Q <- RM_unif(N = 5, min = 2, max = 10, cplx = TRUE, herm = TRUE)

}
