% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpca_b.R
\name{mlpca_b}
\alias{mlpca_b}
\title{Maximum likelihood principal component analysis for mode B error conditions}
\usage{
mlpca_b(X, Xsd, p)
}
\arguments{
\item{X}{MxN matrix of measurements.}

\item{Xsd}{MxN matrix of measurements error standard deviations.}

\item{p}{Rank of the model's subspace, p must be than the minimum of M and N.}
}
\value{
The parameters returned are the results of SVD on the estimated
subspace. The quantity Ssq represents the sum of squares of weighted
residuals. All the results are nested in a list format.
}
\description{
Performs maximum likelihood principal components analysis for
mode B error conditions (independent errors, homoscedastic within a column).
Equivalent to perfoming PCA on data scaled by the error SD, but results are
rescaled to the original space.
}
\details{
The returned parameters, U, S and V, are analogs to the
truncated SVD solution, but have somewhat different properties since they
represent the MLPCA solution. In particular, the solutions for different
values of p are not necessarily nested (the rank 1 solution may not be in
the space of the rank 2 solution) and the eigenvectors do not necessarily
account for decreasing amounts of variance, since MLPCA is a subspace
modeling technique and not a variance modeling technique.
}
\examples{

library(RMLPCA)
data(data_clean)
data(data_error_b)
data(sds_b)

# data that you will usually have on hands
data_noisy <- data_clean + data_error_b

# run mlpca_b with rank p = 2
results <- RMLPCA::mlpca_b(
  X = data_noisy,
  Xsd = sds_b,
  p = 2
)

# estimated clean dataset
data_cleaned_mlpca <- results$U \%*\% results$S \%*\% t(results$V)
}
\references{
Wentzell, P. D.
"Other topics in soft-modeling: maximum likelihood-based soft-modeling
methods." (2009): 507-558.
}
