% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESTF_gamma.R
\name{ESTF_gamma}
\alias{ESTF_gamma}
\title{Estimating model parameter gamma(no-purchase utility).}
\usage{
ESTF_gamma(
  eta_wo_k,
  Attr,
  Choice_Set_List,
  Alts_Same_Choice_Set,
  Is_Purchase,
  Base_Prod,
  Num_Prod,
  Num_Attr,
  cond
)
}
\arguments{
\item{Attr}{list, a set of data frame in which alternative specific variables.}

\item{Choice_Set_List}{list, product code included for each choice set.}

\item{Alts_Same_Choice_Set}{list, for internal calculation, a list of data exposed to the same choice set.}

\item{Is_Purchase}{list, for internal calculation, list of customers who are
exposed to the same choice set who purchased the product. If purchased 1, otherwise 0.}

\item{Base_Prod}{numeric, the baseline product number}

\item{Num_Prod}{numeric, the number of all products in observed data.}

\item{Num_Attr}{numeric, the number of attributes in observed data.}

\item{cond}{numeric, the value associated with prop, which is the argument of the \code{\link{rmm}} function. (1-prop)/prop.}
}
\value{
The estimated value of parameters except gamma(no-purchase utility).
}
\description{
Estimating model parameter gamma(no-purchase utility) given estimated model parameters. Internal function that users should not call directly.
}
\keyword{internal}
