% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmm_reshape_Rcpp.R
\name{rmm_reshape}
\alias{rmm_reshape}
\title{Reshape Long-Format Data}
\usage{
rmm_reshape(data, idvar, resp, alts, asv, min_obs)
}
\arguments{
\item{data}{data frame, a 'Long-Format' transaction data.}

\item{idvar}{character, variable name representing each individual's id in the transaction data.}

\item{resp}{character, variable name representing result of a individual choice.}

\item{alts}{character vector, variable names representing a alternatives.}

\item{asv}{character vector, variable names representing a alternative specific variables.}

\item{min_obs}{numeric, specify the minimum observation for each choice set in the transaction data.}
}
\value{
The 'Wide-Format' data and various information required for the \code{\link{rmm}} function.
}
\description{
This function reshapes a 'Long-Format' data (with the repeated measurements in separate rows) to 'Wide-Format' data  (with repeated measurements in separate columns of the same row).
The reshaped 'wide-format' data is an S3 class called 'rmm_data' and contains information for fitting the model with the \code{\link{rmm}} function.
Users who want to use the rmm function must first use the rmm_reshape function. The \code{\link{rmm}} function receives only S3 class 'rmm_data' as input.
}
\examples{
\donttest{
data(Hotel_Long)

rst_reshape <- rmm_reshape(data=Hotel_Long, idvar="Booking_ID",
resp="Purchase", alts="Room_Type", asv="Price", min_obs=30)

class(rst_reshape)  # "rmm_data"
ls(rst_reshape)     # "Alts_Code_Desc" "ASV" "asv_name" "data_wide"
                    # "Rem_Choice_Set"     "Removed_Choice_Set"

rst_reshape$data_wide  # reshaped data
}
}
\seealso{
\code{\link{rmm}} for estimating parameters.
}
