% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_roc.R
\name{add_roc_curve}
\alias{add_roc_curve}
\title{Add a ROC curve plot to an existing one}
\usage{
add_roc_curve(
  data,
  response = NULL,
  predictor = NULL,
  .condition = NULL,
  .label = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}

\item{.label}{A string representing the name used in labels.

If \code{NULL}, variable name from \code{predictor} will be used as label.}
}
\value{
A ggplot layer instance object.
}
\description{
Add a ROC curve to an existing ROC plot.
}
\examples{
plot_roc_curve(iris, response = Species, predictor = Sepal.Width) +
 add_roc_curve(iris, response = Species, predictor = Sepal.Length)
}
