% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutscores.r
\name{cutscores}
\alias{cutscores}
\title{Function to compute optimal cut-off scores}
\usage{
cutscores(outcome, predictor)
}
\arguments{
\item{outcome}{The outcome variable indicating the status in the form of a data frame or matrix. 
This variable is typically coded as 0 (positive) and 1 (negative).}

\item{predictor}{A numerical vector of scores used to predict the status of the outcome. This variable 
should be of the same length as the outcome variable (i.e., two variables are 
from the same data set and also of the same number of data rows).}
}
\value{
A list of two objects: (1) summary statistics of selected cut scores, and (2) detailed
information of each used cut score and corresponding classification statistics.
\item{Summary}{Summary statistics of selected cut scores. Specifically, \cr
 * Cut.off, the select cut-off scores according to different criteria\cr
 * SEN, Sensitivity, also true positive rate, the y-axis of the ROC.\cr
 * SPE, Specificity, also true negative rate. \cr
 * 1-SPE, the x-axis of the ROC. \cr
 * Youden.Index. \cr
 * TP, true positives. \cr
 * FP, false positives. \cr 
 * FN, false negatives.\cr
 * TN, true negatives.}
\item{Details}{Detailed information of each used cut score and corresponding classification statistics.}
}
\description{
This function computes the optimal cut-off scores based on sensitivity, specificity, and the
Youden Index (Youden, 1950) <doi:10.1002/1097-0142(1950)3:1<32::AID-CNCR2820030106>3.0.CO;2-3>.
}
\examples{
 
#read the example data
data(ROC.data.ex)
#run the function
result<-cutscores(ROC.data.ex$outcome, ROC.data.ex$predictor)
#obtain results
result$Summary
result$Details 
}
\references{
{
 Youden, W.J. (1950). 
"Index for rating diagnostic tests."
 Cancer,3, 32-35. doi:10.1002/1097-0142(1950)3:1<32::AID-CNCR2820030106>3.0.CO;2-3. 
}
}
