% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{RPhosFate}
\alias{RPhosFate}
\alias{catchment}
\title{Initialise project}
\usage{
RPhosFate(...)

catchment(...)
}
\arguments{
\item{\dots}{Arguments used to initialise the project. See argument sections
for further information.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object.
}
\description{
Initialises a project from scratch or loads the state of an existing one
utilising \emph{GeoTIFF} (*.tif) raster files from, by convention, the following
three project root subdirectories:
\itemize{
\item \emph{Input}
\item \emph{Intermediate}
\item \emph{Result}
}

See subdirectory sections for further information.

\code{catchment} is an alias for \code{RPhosFate}.
}
\section{\emph{Input} subdirectory}{

This directory holds all possible user input raster data (flow obstacles like
roads must be considered during the generation of the flow accumulation layer
and must also be cut out from it in order to be properly respected):
\itemize{
\item \emph{acc_inf:} D-infinity flow accumulations in number of upslope grid
cells required for everything.
\item \emph{CFa:} (R)USLE C-factors required for \code{\link{erosion}}.
\item \emph{cha:} Channel cells required for everything (\code{1}: channel cell, \code{NA}: no
channel cell).
\item \emph{clc:} Clay contents of top soils in \% required for substance
\code{\link{emission}}s.
\item \emph{dem:} Digital elevation model in m a.s.l. (optional).
\item \emph{dir_inf:} D-infinity flow directions in azimuth degrees
measured from north (0 to 360 clockwise) required for
\code{\link{transportPrerequisites}} and substance
\code{\link{transport}}.
\item \emph{fid:} Field IDs (optional).
\item \emph{KFa:} (R)USLE K-factors required for \code{\link{erosion}}.
\item \emph{lue:} Land use classes (optional).
\item \emph{man:} Manning's roughness coefficients required for substance
\code{\link{transport}}.
\item \emph{xxc:} Substance contents of top soils in mg/kg required for substance
\code{\link{emission}}s, for example, \emph{ppc} for PP top soil contents.
\item \emph{rds:} Road cells required for \code{\link{transportPrerequisites}} (\code{0}: road cell
without subsurface drainage, \code{1}: road cell with subsurface drainage, \code{NA}:
no road cell).
\item \emph{RFa:} (R)USLE R-factors required for \code{\link{erosion}}.
\item \emph{slp_inf:} D-infinity slopes in \% required for everything.
\item \emph{wsh:} Watershed (optional).
}
}

\section{\emph{Intermediate} subdirectory}{

This directory holds intermediate calculations:
\itemize{
\item \emph{inl:} Cells representing inlets at roads (storm drains).
\item \emph{LFa:} L-factors.
\item \emph{rip:} Cells representing the riparian zones within channel cells.
\item \emph{SFa:} RUSLE S-factors.
\item \emph{slp_cap:} Capped slopes in \%.
}
}

\section{\emph{Result} subdirectory}{

This directory holds the model results:
\itemize{
\item \emph{ero:} Erosion in t/cell/yr.
\item \emph{xxe:} Substance emissions in kg/cell/yr, for example, \emph{ppe} for PP
emissions.
\item \emph{xxr:} Substance retentions in t/cell/yr (SS) or kg/cell/yr, for example,
\emph{ppr} for PP retentions.
\item \emph{xxt:} Substance transports in t/cell/yr (SS) or kg/cell/yr, for example,
\emph{ppt} for PP transports.
\item \emph{xxt_cld:} Substance cell loads in t/cell/yr (SS) or kg/cell/yr, for
example, \emph{ppt_cld} for PP cell loads.
\item \emph{xxt_ctf:} Substance cell transfers in t/cell/yr (SS) or kg/cell/yr,
for example, \emph{ppt_ctf} for PP transfers.
\item \emph{xxt_inp:} Substance inputs into surface waters in t/cell/yr (SS) or
kg/cell/yr, for example, \emph{ppt_inp} for PP inputs into surface waters.
\item \emph{xxt_out:} Substance outlet loads of subsurface drainages in t/cell/yr
(SS) or kg/cell/yr, for example, \emph{ppt_out} for PP outlet loads.
}
}

\section{Data management and processing arguments}{

\itemize{
\item \code{cv_dir}: A character vector specifying the project root (first position)
and optionally the Monte Carlo input data directory (second position).
\item \code{ls_ini}: A logical scalar specifying if the state of an existing project
shall be loaded from disk (defaults to \code{FALSE}). Parameters or substance
parameter values specified via the \code{...} argument take precedence over loaded
ones.
\item \code{is_ths}: An integer scalar holding the number of threads to use for
processing (defaults to 1).
\item \code{is_MCi}: An integer scalar specifying the current Monte Carlo iteration if
applicable (defaults to \code{integer()}, which means Monte Carlo simulation mode
is disabled).
\item \code{cv_MCl}: A character vector specifying the names of the layers, which
shall be written to disk with the associated Monte Carlo iteration in their
filenames upon calling the appropriate methods (defaults to \code{"xxt"}; no
effect in case Monte Carlo simulation mode is disabled).
}
}

\section{Model parameter arguments}{

\itemize{
\item \code{ns_slp_min}: A numeric scalar specifying the minimum bounding slope in \%
(defaults to \code{1.0}).
\item \code{ns_slp_max}: A numeric scalar specifying the maximum bounding slope in \%
(defaults to \code{999.0}).
\item \code{ns_rhy_a}: A numeric scalar specifying a network constant depending on the
discharge frequency needed for the calculation of the hydraulic radius, which
in turn is a prerequisite for substance transport (defaults to \code{0.09}
representing a discharge frequency of approximately six years).
\item \code{ns_rhy_b}: A numeric scalar specifying a geometry scaling exponent
depending on the discharge frequency needed for the calculation of the
hydraulic radius, which in turn is a prerequisite for substance transport
(defaults to \code{0.50} representing a discharge frequency of approximately six
years).
\item \code{ns_cha_rto}: A numeric scalar specifying the ratio of the channel to the
cell width determining the widths of the riparian zones required for
substance \code{\link{transport}} (defaults to \code{0.5}).
\item \code{ns_man_rip}: A numeric scalar specifying Manning's roughness coefficient
of the riparian zones within channel cells required for substance
\code{\link{transport}} (defaults to \code{0.32}).
\item \code{ns_man_cha}: A numeric scalar specifying Manning's roughness coefficient
of the channel within channel cells required for substance \code{\link{transport}}
(defaults to \code{0.04}).
\item \code{ns_dep_ovl}: A numeric scalar specifying the overland deposition rate per
second required for substance \code{\link{transport}} (calibration parameter; no
default).
\item \code{ns_dep_cha}: A numeric scalar specifying the channel deposition rate per
second required for substance \code{\link{transport}} (calibration parameter; no
default).
\item \code{nv_tfc_inl}: A named numeric vector specifying the inlet transfer
coefficients required for substance \code{\link{transport}}, for example, \code{c(SS = 0.6, PP = 0.6)} (no default).
\item \code{nv_enr_rto} A named numeric vector specifying the substance enrichment
ratios required for substance except SS \code{\link{transport}}, for example, \code{c(PP = 2.0)} (calibration parameter; no default).
\item \code{nm_olc}: A two column numeric \code{\link{matrix}} specifying one or more catchment
outlet coordinates required for the in-channel retention ratio of
\code{\link{calibrationQuality}} (no default).
\item \code{df_cdt}: A \code{\link{data.frame}} with calibration data, which must have at least
the following three columns and one or more columns with substance river
loads in t/yr (no default):
\itemize{
\item \emph{ID:} ID(s) of the gauge(s)
\item \emph{x:} x-coordinate(s) of the gauge(s)
\item \emph{y:} y-coordinate(s) of the gauge(s)
}
}
}

\section{Monte Carlo simulation mode}{

This mode can make use of repeated random samples, i.e. raster data, of
distributions of about all input data. The filenames of the Monte Carlo input
raster data must contain the specified iteration, for example, \emph{CFa12.tif}
for the twelfth iteration of the C-factors input data, and can reside in a
separate directory. In case no Monte Carlo raster file is found for a certain
layer in the designated directory, the respective project root subdirectory
is searched for one and finally the \dQuote{normal} project input raster data
is utilised.
}

\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()

# initialise project from scratch
x <- RPhosFate(
  cv_dir = cv_dir,
  ns_dep_ovl = 25e-4,
  ns_dep_cha = 0.0,
  nv_tfc_inl = c(SS = 0.6, PP = 0.6),
  nv_enr_rto = c(PP = 2.0),
  nm_olc = matrix(c(4704255, 2795195), ncol = 2L),
  df_cdt = read.table(
    file.path(cv_dir, "cdt.txt"),
    header = TRUE,
    stringsAsFactors = FALSE
  )
)

# load state of existing project in Monte Carlo simulation mode
x <- RPhosFate(
  cv_dir = c(
    cv_dir,
    system.file("tinytest", "testProject", package = "RPhosFate")
  ),
  ls_ini = TRUE,
  is_MCi = 1L,
  cv_MCl = c("xxt", "xxt_cld")
)}

}
\seealso{
\code{\link{saveState}}, \code{\link{demoProject}}
}
