% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_procrustes.R
\name{procrustesData}
\alias{procrustesData}
\title{Return procrustes data on a map comparison}
\usage{
procrustesData(
  map,
  comparison_map,
  optimization_number = 1,
  comparison_optimization_number = 1,
  antigens = TRUE,
  sera = TRUE,
  translation = TRUE,
  scaling = FALSE
)
}
\arguments{
\item{map}{The acmap data object}

\item{comparison_map}{The acmap data object to procrustes against}

\item{optimization_number}{The map optimization to use in the procrustes
calculation (other optimization runs are discarded)}

\item{comparison_optimization_number}{The optimization run int the comparison
map to compare against}

\item{antigens}{Antigens to include (specified by name or index or TRUE/FALSE
for all/none)}

\item{sera}{Sera to include (specified by name or index or TRUE/FALSE for
all/none)}

\item{translation}{Should translation be allowed}

\item{scaling}{Should scaling be allowed (generally not recommended unless
comparing maps made with different assays)}
}
\value{
Returns a list with information on antigenic distances between the
aligned maps, and the rmsd of the point differences split by antigen
points, serum points and total, or all points. The distances are a vector
matching the number of points in the main map, with NA in the position of
any points not found in the comparison map.
}
\description{
Returns information about how similar point positions are in two maps,
to get an idea of how similar antigenic positions are in for example
maps made from two different datasets.
}
\seealso{
Other functions to compare maps: 
\code{\link{matchStrains}},
\code{\link{procrustesMap}()},
\code{\link{realignMap}()},
\code{\link{realignOptimizations}()}
}
\concept{functions to compare maps}
