% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_methods.R
\name{view.acmap}
\alias{view.acmap}
\title{Viewing racmap objects}
\usage{
\method{view}{acmap}(
  x,
  optimization_number = 1,
  ...,
  .jsCode = NULL,
  .jsData = NULL,
  select_ags = NULL,
  select_sr = NULL,
  show_procrustes = NULL,
  show_diagnostics = NULL,
  num_optimizations = 1,
  options = list()
)
}
\arguments{
\item{x}{The acmap data object}

\item{optimization_number}{The optimization number to view}

\item{...}{Additional arguments to be passed to \code{RacViewer()}}

\item{.jsCode}{Additional javascript code to be run after map has been loaded
and rendered}

\item{.jsData}{Any data to supply to the .jsCode function}

\item{select_ags}{A vector of antigen indices to select in the plot}

\item{select_sr}{A vector of serum indices to select in the plot}

\item{show_procrustes}{If the map contains procrustes information, should
procrustes lines be shown by default?}

\item{show_diagnostics}{If the map contains diagnostics information like
stress blobs or hemisphering, should it be shown by default?}

\item{num_optimizations}{Number of optimization runs to send to the viewer
for inclusion in the "optimizations" pane.}

\item{options}{A named list of viewer options to pass to
\code{RacViewer.options()}}
}
\value{
Returns an htmlwidget object
}
\description{
View a racmap object in the interactive viewer.
}
\seealso{
Other functions to view maps: 
\code{\link{RacViewer.options}()},
\code{\link{RacViewer}()},
\code{\link{export_viewer}()},
\code{\link{ggplot.acmap}()},
\code{\link{mapGadget}()},
\code{\link{plot.acmap}()},
\code{\link{setLegend}()},
\code{\link{view.default}()},
\code{\link{view}()}

Other shiny app functions: 
\code{\link{RacViewer-shiny}},
\code{\link{runGUI}()}
}
\concept{functions to view maps}
\concept{shiny app functions}
