% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{QisSurjective}
\alias{QisSurjective}
\title{Check surjectivity}
\usage{
QisSurjective(M)
}
\arguments{
\item{M}{a matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
A Boolean value indicating whether the linear map corresponding to 
  \code{M} is surjective.
}
\description{
Checks whether a rational matrix represents a surjective linear 
  map.
}
\examples{
library(RationalMatrix)
set.seed(666L)
M <- matrix(rpois(35L, 1), 7L, 5L)
QisSurjective(M)
}
