% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{Qkernel}
\alias{Qkernel}
\title{Kernel of a rational matrix}
\usage{
Qkernel(M)
}
\arguments{
\item{M}{a matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
A character matrix representing a basis of the kernel of \code{M}. 
  Note that this basis is not orthogonal.
}
\description{
Kernel (null-space) of a rational matrix.
}
\examples{
library(RationalMatrix)
set.seed(666L)
M <- matrix(rpois(30L, 6), 10L, 3L)
M <- cbind(M, M[,1] + M[,2], M[,2] + 2L*M[,3])
Qkernel(M)
}
