#include "abc_000_warning.h"
#include "abc_001_config.h"
#include <math.h>
#include <string.h>
#include <time.h>
#include "abc_datatype.h"
#include "abc_blas_lapack_lib.h"
#include "abc_ide_util.h"  
#include "abc_common.h"    
#include "abc_ts_func.h"
#include "abc_date.h"
#include "globalvars.h"
#include "beastv2_func.h"    
#include "beastv2_io.h"
#include <stdio.h>	          
#define CondErrMsgRet0(cond,...)   if(cond) { r_error(__VA_ARGS__); return 0;}
#define CondErrActionRet0(cond,Action,...)   if(cond) { (Action) ;r_error(__VA_ARGS__); return 0;}
#define ifelse(cond,a,b)  ((cond)?(a):(b))
static int  GetArg_0th_Data(VOIDPTR prhs[],int nrhs,BEAST2_IO_PTR _OUT_ io) {
	CondErrMsgRet0( nrhs < 2L,"ERROR: At least one input argument is needed!\n" );
	VOIDPTR DATA=prhs[1];
	int     numel=GetNumberOfElements(DATA);
	if (IsEmpty(DATA)||( !(IsNumeric(DATA) && numel > 2) && !(IsStruct(DATA) && numel >=1) && !IsCell(DATA) ) ) {
		r_error("ERROR: The input data should be numeric and must be long enough.\n");
		return 0;
	}
	I32       q=0;
	VOID_PTR  Y=NULL;
	if ((IsStruct(DATA) && numel >=1)||IsCell(DATA)) {
		q=numel;
		io->pdata=malloc(sizeof(VOID_PTR) * q);
		io->dtype=malloc(sizeof(DATA_TYPE) * q);
		for (int i=0; i < q; i++) {
			Y=GetFieldByIdx(DATA,i);
			io->pdata[i]=GetData(Y);
			io->dtype[i]=GetDataType(Y);
		}		
	} else {
		q=1;
		io->pdata=malloc(sizeof(VOID_PTR) * q);
		io->dtype=malloc(sizeof(DATA_TYPE) * q);
		io->pdata[0]=GetData(DATA);
		io->dtype[0]=GetDataType(DATA);
		Y=DATA;
	}
	for (int i=0; i < q; i++) {
		CondErrMsgRet0( io->dtype[i]==DATA_UNKNOWN,"ERROR: The input data has an uknown numeric type!\n");		
	}
	io->q=q;
	io->timedim=UnknownStatus;   
	I32 ndims=GetNumOfDim(Y);	
	if (ndims==0||	 
		ndims==1)      
	{
		I32 N=GetNumberOfElements(Y);
		io->ndim=1L;
		io->dims[0]=N;
		io->dims[1]=1L;
		io->dims[2]=1L; 
		io->timedim=1L; 		
	}
	else if (ndims==2) {
		int N=GetDim1(Y);
		int M=GetDim2(Y);
		if (min(N,M)==1L) {
			N=max(N,M),
			io->ndim=1L;
			io->dims[0]=N;
			io->dims[1]=1L;
			io->dims[2]=1L;
			io->timedim=1L;
		} else {
			io->ndim=2L;
			io->dims[0]=N;
			io->dims[1]=M;
			io->dims[2]=1L; 
		}
	}
	else if (ndims==3) {
		io->ndim=3L;
		GetDimensions(Y,io->dims,3L);	
	}
	else {
		r_printf("ERROR: The maximum dimension allowed is 3 when data is a 3D stack of images over time,but the input has a dimension of %d.\n",ndims);
		return 0;
	}
	return 1;
}
static float ParsePeriod(BEAST2_IO_PTR _OUT_ io);
static int   Parse_whichDimIsTime(BEAST2_IO_PTR _OUT_ io,int Nrawtime,int userWhichDim);
static int  GetArg_1st_MetaData(VOIDPTR prhs[],int nrhs,BEAST2_IO_PTR _OUT_ io) {
	BEAST2_METADATA_PTR meta=&io->meta;
	meta->nrhs=nrhs;
	int METADATA_NONE=_False_;
	int METADATA_NumericScalar=_False_;
	int METADATA_NumericVector=_False_;
	int METADATA_CharVector=_False_;
	int METADATA_CharScaler=_False_;
	int METADATA_Struct=_False_;
	int METADATA_OTHER=_False_;
	VOIDPTR pmeta=(nrhs < 3) ? NULL : prhs[2L];
	VOIDPTR TIMEobj=NULL;
	int     userWhichDimIsTime=UnknownStatus;
	if ( pmeta==NULL||IsEmpty(pmeta) ) {
		METADATA_NONE=_True_;
	} else if ( IsNumeric(pmeta) ) {
		int  numel=GetNumberOfElements(pmeta);
		if      (numel==0) METADATA_NONE=_True_;
		else if (numel==1) METADATA_NumericScalar=_True_;
		else if (numel > 1 ) METADATA_NumericVector=_True_,TIMEobj=pmeta;
		else 			     METADATA_OTHER=_True_;
	} else if ( IsChar(pmeta) ) {
		int numel=GetNumberOfElements(pmeta);
		if      (numel==0) METADATA_NONE=_True_;
		else if (numel==1) METADATA_CharScaler=_True_;
		else if (numel > 1 ) METADATA_CharVector=_True_,TIMEobj=pmeta;
		else 			     METADATA_OTHER=_True_;
	} else if (IsStruct(pmeta) ) {
		METADATA_Struct=_True_;
		TIMEobj=GetField123Check(pmeta,"time",2) ; 
		VOIDPTR  tmp;
		userWhichDimIsTime=(tmp=GetField123Check(pmeta,"whichDimIsTime",2)) ? GetScalar(tmp) : UnknownStatus;
	} else {
		METADATA_OTHER=_True_;
	}
	CondErrMsgRet0(METADATA_OTHER==_True_,"ERROR: The 'metadata' parameter given is of unsupported type.\n");
	meta->hasSeasonCmpnt=UnknownStatus;
	I08 ISDATE=UnknownStatus;
	F32 START=getNaN();
	F32 DT=getNaN();
	F32 PERIOD=getNaN();
	if (METADATA_NONE||METADATA_NumericScalar||METADATA_CharVector||METADATA_CharScaler||METADATA_NumericVector) {
		START=getNaN();
		DT=getNaN();
		PERIOD=getNaN();
		if (METADATA_NumericScalar) {
			PERIOD=GetScalar(pmeta);
			if (!IsNaN(PERIOD) ) {
				if (PERIOD <=0.) {
					q_warning("WARNING: A negative or zero value of period (%g) means no periodic/seasonal component in the input time series!\n",meta->period);
				} else{ 
					CondErrMsgRet0(!_IsAlmostInteger(PERIOD),
						"ERROR: When metadata is supplied as a single number %g,it must be an integer to specify the period of the regular time seires!\n",meta->period);
					PERIOD=round(PERIOD);
				}
			}
			meta->hasSeasonCmpnt=PERIOD <=0.0? _False_ :_True_; 
		}	else if (METADATA_CharScaler) {
			char period[10+1];
			GetCharArray(pmeta,period,10L);
			CondErrMsgRet0( strcicmp(period,"none") !=0,"ERROR: When metadata is supplied as a string to speciify period,it can only be 'none'!\n");
 			meta->hasSeasonCmpnt=_False_;
			PERIOD=0.0;
		}	else {
			meta->hasSeasonCmpnt=_True_;
		}
		meta->seasonForm=ifelse( meta->hasSeasonCmpnt,'S','N');
		meta->hasOutlierCmpnt=_False_;		
		meta->detrend=_False_;
		meta->deseasonalize=_False_;
		meta->missingValue=getNaN();
		meta->maxMissingRate=0.75f;
	}
	else if (METADATA_Struct) {
		VOIDPTR  tmp;
		tmp=GetField123Check(pmeta,"startTime",2); 
		TimeScalarInfo timevalue;
		Parse_SingelDateObject(tmp,&timevalue);
		START=timevalue.value;
		if (timevalue.unit=='Y')  ISDATE=_True_;
		CondErrMsgRet0(timevalue.unit=='B',"ERROR: cannot interpret the metadata$startTime input,'\n");
		tmp=GetField123Check(pmeta,"deltaTime",3);
		Parse_TimeIntervalObject(tmp,&timevalue);
		DT=timevalue.fyear;
		if (timevalue.unit !='U' && timevalue.unit !='B') ISDATE=_True_;
		CondErrMsgRet0(timevalue.unit=='B',"ERROR: cannot interpret the metadata$deltaTime input,'\n");
		CondErrMsgRet0(DT             <=0,"ERROR: metadata$deltaTime must be a positive time interval!\n");
		tmp=GetField123Check(pmeta,"period",2);
		Parse_TimeIntervalObject(tmp,&timevalue);
		PERIOD=timevalue.fyear;
		if (timevalue.unit !='U' && timevalue.unit !='B') ISDATE=_True_;
		CondErrMsgRet0(timevalue.unit=='B',"ERROR: cannot interpret the metadata$period input,'\n");
		if (PERIOD<=0) {
			meta->hasSeasonCmpnt=_False_;
			q_warning("WARNING: A negative or zero value of period (%g) indicates no periodic/seasonal component in the input time series!\n",PERIOD);
		}
		if (PERIOD > 0 && PERIOD/DT >=2.0) {
			meta->hasSeasonCmpnt=_True_;			
		}
		if (PERIOD > 0 && PERIOD/DT < 2.0) {
			meta->hasSeasonCmpnt=_False_;
			q_warning("WARNING: The value metadata$period/metadata$deltTime=%g/%g=%g is unreasonalbe for a siginal with seasonal componet,so no seasonal component is "
				"assumed and the trend-only model is fitted. Perios is also set to 0.0\n",PERIOD,DT,PERIOD/DT);
			PERIOD=0;
		}
		tmp=( tmp=GetField123Check(pmeta,"season",2),tmp && !IsChar(tmp) ? NULL : tmp);
		char season[20+1];
		GetCharArray(tmp,season,20); 
		ToUpper(season);
		char a=season[0],b=season[1];
	   if (meta->hasSeasonCmpnt==_False_ && a !='N' && a !='\0' ) {
			   q_warning("WARNING: A confilict found between metadata$season=%s and period=%g. '%s' suggests a time series with periodic variations but "
				         "period=%g or period='none' suggests a trend-only time series without any periodic variations. The season parameter is "
				         "ignored and no seasonal component is assumed for the input.\n",season,PERIOD,season,PERIOD);
		} else if  (tmp  && IsChar(tmp) ) {			
			int  hasSeasonCmpt_bySeasonStr=_True_;			
			if    ((a=='N' && b=='O')||a=='\0')		hasSeasonCmpt_bySeasonStr=_False_;								
			else if (a=='H' && b=='A') 					hasSeasonCmpt_bySeasonStr=_True_,meta->seasonForm='S';    	
			else if (a=='D' && b=='U')					hasSeasonCmpt_bySeasonStr=_True_,meta->seasonForm='D';		
			else if (a=='S' && b=='V')					hasSeasonCmpt_bySeasonStr=_True_,meta->seasonForm='V';		
			else {
				hasSeasonCmpt_bySeasonStr=_True_;
				meta->seasonForm='S';  
				q_warning("WARNING: metadata$season='%s' has an unrecongizable string. The default season='harmonic' is used instead.\n",season);
			}
			if (meta->hasSeasonCmpnt==_True_ && hasSeasonCmpt_bySeasonStr==_False_) {
				hasSeasonCmpt_bySeasonStr=_True_;
				meta->seasonForm='S';
				q_warning("WARNING: A confilict found between metadata$season='none' and period=%g. season='none' suggests a time series with "
					       "no periodic variations but period=%g suggests otherwise. The season='none' parameter is ignored and "
					      "the data is assumed to have a seasonal component.\n",PERIOD,PERIOD);
			}
			meta->hasSeasonCmpnt=hasSeasonCmpt_bySeasonStr;
		} 	else	{
			if (meta->hasSeasonCmpnt==UnknownStatus||meta->hasSeasonCmpnt==_True_) {
				meta->hasSeasonCmpnt=_True_;
				meta->seasonForm='S';
				q_warning("WARNING: metadata$season is either missing or not given as a valid specifier string (e.g.,none,harmonic,or dummy). A default season='harmonic' is assumed.\n");
			}
		}	
		if (meta->seasonForm=='V') {
			meta->svdTerms_Object=GetFieldCheck(pmeta,"svdTerms");
			meta->svdYseason_Object=GetFieldCheck(pmeta,"svdYseason");
		}
		meta->hasOutlierCmpnt=(tmp=GetField123Check(pmeta,"hasOutlierCmpnt",2)) ? GetScalar(tmp) : _False_;
		meta->detrend=(tmp=GetField123Check(pmeta,"detrend",3)) ?  GetScalar(tmp)   : _False_;
		meta->deseasonalize=(tmp=GetField123Check(pmeta,"deseasonalize",3)) ?  GetScalar(tmp)   : _False_;
		meta->missingValue=(tmp=GetField123Check(pmeta,"missingValue",0))   ? GetScalar(tmp)   : getNaN();
		meta->maxMissingRate=(tmp=GetField123Check(pmeta,"maxMissingRate",0)) ? GetScalar(tmp)   : 0.75;
	} 
	else {
		CondErrMsgRet0(  _True_,"ERROR: The 'metadata' parameter given is of unsupported type.\n");
	}
	CondErrMsgRet0(meta->hasSeasonCmpnt==UnknownStatus,"ERROR: Cnnot determine whether the input time series has a seasonal/periodic componnet or net.\n");
	if (meta->hasSeasonCmpnt==0) PERIOD=0;        
	if (DT  < 0.)                  DT=getNaN(); 
	TimeVecInfo tvec={ 0 };
	TimeVec_init(&tvec);
     if (TIMEobj) { 
		int Nrawtime=TimeVec_from_TimeObject(TIMEobj,&tvec);        
	    if(tvec.isDate==1) ISDATE=_True_;                            
		CondErrMsgRet0( Nrawtime<=1,"ERROR: Unable to read and intepret 'time' or 'metadata$time'!\n");
		userWhichDimIsTime=Parse_whichDimIsTime(io,Nrawtime,userWhichDimIsTime);  
		CondErrMsgRet0(userWhichDimIsTime <=0,"ERROR: Unable to dtermine which dimo of the input data refers to the time'!\n");
	} else {
		int Nrawtime=0;
		userWhichDimIsTime=Parse_whichDimIsTime(io,Nrawtime,userWhichDimIsTime);
		CondErrMsgRet0(userWhichDimIsTime <=0,"ERROR: Unable to dtermine which dimo of the input data refers to the time'!\n");
		int isDefaultDeltaTime=0;
		int isDefaultStartTime=0;
		if (IsNaN(START)) {
			START=1.f;
			isDefaultStartTime=1L;
		}
		if (IsNaN(DT)) {
			DT=1.f;
			isDefaultDeltaTime=1L;
		}
		char *warningMsg="WARNING: If the input data is regular and ordered in time,the times of individual datapoints are determined fully by 'metadata$startTime' and 'metadata$deltaTime'.";
		if (isDefaultDeltaTime && isDefaultStartTime) {
			q_warning("%s But startTime and deltaTime are missing and a default value 1 is used for both!\n",warningMsg);
			if (ISDATE==_True_) { 
				q_warning("WARNING! The default sartTime=1 and deltaTime=1  are used,but the 'period' field specifies that the time is date\n");
			}
		} else if (isDefaultStartTime) {
			q_warning("%s But startTime is missing and a default value 1 is used!\n",warningMsg);
			if (ISDATE==_True_) { 
				q_warning("WARNING! The default startTime=1 is used,but the 'period' field specifies that the time is date\n");
			}
		} else if (isDefaultDeltaTime) {
			q_warning("%s But deltaTime is missing and a default value 1 is used!\n",warningMsg);
			if (ISDATE==_True_) { 
				q_warning("WARNING! The default deltaTime=1 is used,but the 'period' field specifies that the time is date\n");
			}
		}
		int N=io->dims[userWhichDimIsTime - 1];   
		TimeVec_from_StartDeltaTime(&tvec,START,DT,N,ISDATE);         
		PERIOD=tvec.isDateNum==1 ? PERIOD * 365 : PERIOD; 
		START=tvec.data_start;   
		DT=tvec.data_dt;      
	}
	ISDATE=ISDATE==UnknownStatus ? _False_ : ISDATE; 
	TimeVec_SortCheckRegularOrder(&tvec); 
	tvec.isDate=ISDATE;
	tvec.data_period=PERIOD;
	tvec.out.start=START; 
	tvec.out.dT=DT;  
	TimeVec_UpdateUserStartDt(&tvec); 
	if (TIMEobj && IsNaN(DT)) {
		F32 dT_new=tvec.out.dT;
		if (io->T.isRegular==0) {
			if (ISDATE && io->T.out.asDailyTS==1) {
				q_warning("WARNING: The input time series is irregular (or may span across leap years) and BEAST needs to aggregate/resample it into regular data "
					"at a user-specified interval 'metadata$deltaTime/deltat' (for faster computation). But deltaTime is missing,a best guess of it %g year=%g months=%g days is used. "
					"If not making sense,please specify metadata$deltaTime/deltat explicitly. \n",dT_new,dT_new * 12,dT_new * 365.0);
			} else {
				q_warning("WARNING: The input data is irregular and for faster computaiton,BEAST needs to aggregate/resample it into regular data "
					"at a user-specified interval 'metadata$deltaTime/deltat' But deltaTime is missing,a best guess of it %g is used. "
					"If not making sense,please specify metadata$deltaTime/deltat explicitly. \n",dT_new);
			}
		}
	}
	PERIOD=tvec.data_period;
	START=tvec.out.start;
	DT=tvec.out.dT;;
	io->N=tsAggegrationPrepare(&tvec);
	meta->IsPeriodEstimated=0;
	if ( meta->hasSeasonCmpnt && IsNaN(PERIOD)) {		
		io->T=tvec; 
		F32  estPeriod=ParsePeriod(io);
		char* season;
		char* msg;
		season=io->meta.seasonForm=='S' ?      "harmonic" :
			    io->meta.seasonForm=='V' ?     "svd":
			                                     "dummy";
		msg="suggests that the time series has a periodic/seasonal component. \"metadata$period\" is needed but missing.";
		if (estPeriod > 0) {
			q_warning( "WARNING: metadata$season='%s' %s A BEST GUESS of numbers of datapoints per period is %d,giving period=num_sample_per_period * deltaTime "
				"=%d*%g=%g. Please make sure this estimate makes sense; otherwise,the BEAST decomposition result will be incorrect.\n",
				season,msg,(int)estPeriod,(int)estPeriod,DT,DT * estPeriod);
		}	else {
			r_error("ERROR: metadata$season='%s' %s BEAST tried to estimate it via an auotcorrelation method but failed to get a reliable estimate. "
				"Please specify the period value EXPLICILTY. Or if your input has no periodic/seasonal component at all,"
				" set metadata$season='none' or period=0,which will fit a trend-only model.\n",season,msg);
			return 0;
		}
		meta->IsPeriodEstimated=1;
		PERIOD=estPeriod * DT; 
	}
	if (meta->hasSeasonCmpnt==1) {	
		F32 freq=PERIOD/DT;
		CondErrMsgRet0(freq <=0,"ERROR: BEAST can't handle a time series with a periodic componnet (\"metadata$season='%s'\") but with metadata$period=%g or period='none' specified. If you mean to "
				    "handle trend-only time series,use the trend-only BEAST version by specifying metadata$season='none'.",meta->seasonForm=='S' ? "harmonic" : "dummy",PERIOD);
		CondErrMsgRet0(freq <2,"ERROR: BEAST can't handle a time series with a periodic componnet (\"metadata$season='%s'\") but with metadata$period=%g and metadata$deltaTime=%g specified,"
			                    "which gives only 'period/deltatime=%g' data points per period,If you mean to "
							    "handle trend-only time series,use the trend-only BEAST version by specifying metadata$season='none'.",meta->seasonForm=='S' ? "harmonic" : "dummy",PERIOD,DT,PERIOD/DT);
		CondErrMsgRet0(meta->seasonForm=='D' && !IsNaN(freq) && !_IsAlmostInteger(freq),"ERROR: For a dummy seasonal component (\"metadata$season='dummy'\"),metadata$period=%g must be a multiple of metadata$deltaTime by an INTEGER number. "
			"Your period/deltaTime ratio is %g.",freq* DT,freq);
		CondErrMsgRet0(meta->seasonForm=='V' && !IsNaN(freq) && !_IsAlmostInteger(freq),"ERROR: For a SVD seasonal component (\"metadata$season='dummy'\"),metadata$period=%g must be a multiple of metadata$deltaTime by an INTEGER number. "
			"Your period/deltaTime ratio is %g.",freq* DT,freq);	 
	}
	meta->startTime=START;  
	meta->deltaTime=DT;     
	meta->period=PERIOD/DT;
	TimeVec_kill_fyearArray(&tvec); 
	io->T=tvec;
	return 1;
}
static int Parse_whichDimIsTime(BEAST2_IO_PTR _OUT_ io,int Nrawtime,int userWhichDim) {
		int whichDim_final=userWhichDim;
		if ( io->ndim==1 && userWhichDim !=UnknownStatus && userWhichDim !=1) {
			q_warning("WARNING: metadata$whichDimIsTime=%d is ignored because 'whichDimIsTime' is used only for 2D matrix or 3D array inputs but your input is a 1D vector.\n",userWhichDim);
		}
		if (Nrawtime > 0) {
			int matcheNumDims=(Nrawtime==io->dims[0])+(Nrawtime==io->dims[1])+(Nrawtime==io->dims[2]);
			if (matcheNumDims==0) {
				r_error("ERROR: The input data must have the same length as the time in metadata.\n");
				return -1;
			}
			else if (matcheNumDims==1) {
				int  timeDimMatched;
				if (Nrawtime==io->dims[0])  timeDimMatched=1;
				if (Nrawtime==io->dims[1])  timeDimMatched=2;
				if (Nrawtime==io->dims[2])  timeDimMatched=3;
				if (userWhichDim !=UnknownStatus && userWhichDim !=timeDimMatched) {
					q_warning("WARNING: the specified metadata$whichDimIsTime=%d is ignored; 'whichDimIsTime=%d' is instead used based on the match between the input data and time.\n",userWhichDim,timeDimMatched);
				}
				whichDim_final=timeDimMatched;
			}
			else { 
				if (userWhichDim==UnknownStatus||(io->ndim==2 && userWhichDim !=1 && userWhichDim !=2)) {
					r_error("ERROR: For a 2D matrix input of size [%d x %d] (i.e.,multiple time series),metadata$whichDimIsTime must be given "
						"to tell which dim of the matrix  refers to time. It must take a value out of 1 or 2 only.\n",io->dims[0],io->dims[1]);
					return 0;
				}
				if (userWhichDim==UnknownStatus||(io->ndim==3 && userWhichDim !=1 && userWhichDim !=2 && userWhichDim !=3)) {
					r_error("ERROR: For a 3D array input of size [%d x %d x %d] (i.e.,stacked time series images),metadata$whichDimIsTime must be given "
						"to tell which dim of the 3D array  refers to time. It must take a value out of 1,2 or 3 only.\n",io->dims[0],io->dims[1],io->dims[2]);
					return 0;
				}
				if (userWhichDim>3||userWhichDim <1) {
					r_error("ERROR: the input (whichDimIsTime=%d) muust be an integer of 1,2,or 3.\n",userWhichDim+1);
					return 0;
				} else {
					if (io->dims[userWhichDim - 1] !=Nrawtime) {
						r_error("ERROR: The length of the time dimension of the input (whichDimIsTime=%d) doesn't match the length of time/metadata$time (i.e.,%d!=%d).\n",userWhichDim,io->dims[userWhichDim],Nrawtime);
						return 0;
					}
				}
				whichDim_final=userWhichDim;
			}
		}	
		else {
			if (io->timedim==UnknownStatus) {
				if (userWhichDim==UnknownStatus||(io->ndim==2 && userWhichDim !=1 && userWhichDim !=2)) {
					r_error("ERROR: For a 2D matrix input of size [%d x %d] (e.g.,multiple time series),metadata$whichDimIsTime must be given "
						"to tell which matrix dim refers to time. It must take a value out of 1 or 2 only.\n",io->dims[0],io->dims[1]);
					return 0;
				}
				if (userWhichDim==UnknownStatus||(io->ndim==3 && userWhichDim !=1 && userWhichDim !=2 && userWhichDim !=3)) {
					r_error("ERROR: For a 3D array input of size [%d x %d x %d] (i.e.,stacked time series images),metadata$whichDimIsTime must be given "
						"to tell which aray dim refers to time. It must take a value out of 1,2 or 3 only.\n",io->dims[0],io->dims[1],io->dims[2]);
					return 0;
				}
				whichDim_final=userWhichDim;
			}	else {
				whichDim_final=io->timedim;
			}
		}
		io->timedim=io->meta.whichDimIsTime=whichDim_final;
		if (io->meta.whichDimIsTime==1) { io->rowdim=2,io->coldim=3,io->timedim=1; }
		if (io->meta.whichDimIsTime==2) { io->rowdim=1,io->coldim=3,io->timedim=2; }
		if (io->meta.whichDimIsTime==3) { io->rowdim=1,io->coldim=2,io->timedim=3; }
		io->imgdims[0]=io->dims[io->rowdim - 1];
		io->imgdims[1]=io->dims[io->coldim - 1];
		io->numOfPixels=(I64)io->dims[0] * io->dims[1] * io->dims[2]/io->dims[io->timedim - 1L];
		return whichDim_final;		
}
 static float ParsePeriod(BEAST2_IO_PTR _OUT_ io ) {
		BEAST2_YINFO Yinfo;
		F32PTR       MEMBUF;
		int    N=io->N;		
		int    q=io->q;
		int    Nraw=io->dims[io->timedim - 1];
		F32PTR tmp=malloc(sizeof(F32)*(N*q+N+q+q+q*q+Nraw )); 
		Yinfo.Y=tmp;
		Yinfo.rowsMissing=tmp+N*q;
		Yinfo.mean=tmp+N * q+N;
		Yinfo.sd=tmp+N * q+N+q;
		Yinfo.YtY_plus_alpha2Q=tmp+N * q+N+q+q;
		MEMBUF=tmp+N * q+N+q+q+q*q; 
		F32 nan=getNaN();
		F32 period=nan;
		I32 goodPixelVisited=0;
		I32 MaxNumPixelVisisted=200;
		for (int i=1; i <=io->numOfPixels;++i) {
			BEAST2_fetch_timeSeries(&Yinfo,i,MEMBUF,io);
			Yinfo.nMissing=f32_normalize_multicols_zeroout_nans(Yinfo.Y,Yinfo.rowsMissing,N,N,q,Yinfo.mean,Yinfo.sd);
			U08 skipCurrentPixel=Yinfo.nMissing > (N * io->meta.maxMissingRate);
			if (skipCurrentPixel) {
				continue;
			}		
			for (int j=0; j < q;++j) {
				F32PTR y=Yinfo.Y+j * N;
				for (int k=0; k < Yinfo.nMissing;++k) {
					y[Yinfo.rowsMissing[k]]=nan;
				}
				F32 jthPeriod=DeterminePeriod(y,N);  
				if (j==0) { 
					period=jthPeriod;
					if (period < 0)	break;					
				} else {
					if (jthPeriod !=period ) {
						period=nan;
						break;
					}
				}
			}
			if (period > 0   )                           	break;
			if (++goodPixelVisited > MaxNumPixelVisisted) 	break;
		}
		free(tmp);
	return period;
}
static int __GetPrecPriorType( VOID_PTR S ) {
	VOID_PTR  tmp=GetField123Check(S,"precPriorType",5);
	if (tmp==NULL)
		return UniformPrec;
	if (IsNumeric(tmp)) {
		I32 value=GetScalar(tmp);
		if (value==0) return ConstPrec;
		if (value==1) return UniformPrec;
		if (value==2) return ComponentWise;
		if (value==3) return OrderWise;
		q_warning("WARNING: The arg prior$precPriorType=(%d) is not a valid value; the default prior$precPriorType='%s' is assumed instread!",value,"uniform");
		return UniformPrec;
	} 
	else if (IsChar(tmp)) {
		char str[60+1];
		GetCharArray(tmp,str,60);
		ToUpper(str);
		char a=str[0];
		char c=str[2];
		if (a=='U')				return UniformPrec;
		if (a=='O')				return OrderWise;
		if (a=='C' && c=='M')	return ComponentWise;
		if (a=='C' && c=='N')	return ConstPrec;	
		q_warning("WARNING: The arg prior$precPriorType=(%s) is not recongizable; the default prior$precPriorType='%s' is assumed instread!",str,"uniform");
		return UniformPrec;
	}
	q_warning("WARNING: The arg prior$precPriorType has an supported format or value; the default prior$precPriorType='%s' is assumed instread!","uniform");
	return UniformPrec;
}
static int  GetArg_2nd_Prior__(VOIDPTR prhs[],int nrhs,BEAST2_PRIOR_PTR prior,BEAST2_IO_PTR io)
{	 
	struct PRIOR_MISSING {	
		U08   seasonMinOrder,seasonMaxOrder,trendMinOrder,trendMaxOrder;
		U08   trendMinSepDist,seasonMinSepDist;
		U08   trendMinKnotNum,seasonMinKnotNum,outlierMinKnotNum;
		U08   trendMaxKnotNum,seasonMaxKnotNum,outlierMaxKnotNum;
		U08   trendLeftMargin,trendRightMargin;
		U08   seasonLeftMargin,seasonRightMargin;
		U08   seasonBasisFuncType,trendBasisFuncType,outlierBasisFuncType;
		U08   modelPriorType;
		U08   precPriorType;
		U08   K_MAX;
		U08   sigFactor;
		U08   outlierSigFactor;
		U08   sig2;
		U08   precValue;
		U08   alpha1,alpha2,delta1,delta2;
	} m={0,};
	#define o  (*prior)
	if (nrhs < 4) 	
		memset(&m,1L,sizeof(struct PRIOR_MISSING));
	if (nrhs >=4) {		 
		VOIDPTR S=prhs[3L];
		if (!IsStruct(S)) {
			q_warning("WARNING: The arg 'prior' is ignored because it is not a List/Struct variable.");
			memset(&m,1L,sizeof(struct PRIOR_MISSING));
		}
		else {
			VOIDPTR tmp;
			if (io->meta.hasSeasonCmpnt) {
				o.seasonMinOrder=(tmp=GetField123Check(S,"seasonMinOrder",10)) ? GetScalar(tmp) : (m.seasonMinOrder=1);
				o.seasonMaxOrder=(tmp=GetField123Check(S,"seasonMaxOrder",10)) ? GetScalar(tmp) : (m.seasonMaxOrder=1);
				o.seasonMinSepDist=(tmp=GetField123Check(S,"seasonMinSepDist",10)) ? GetScalar(tmp) : (m.seasonMinSepDist=1);
				o.seasonMinKnotNum=(tmp=GetField123Check(S,"seasonMinKnotNum",10)) ? GetScalar(tmp) : (m.seasonMinKnotNum=1);
				o.seasonMaxKnotNum=(tmp=GetField123Check(S,"seasonMaxKnotNum",10)) ? GetScalar(tmp) : (m.seasonMaxKnotNum=1);
				o.seasonLeftMargin=(tmp=GetField123Check(S,"seasonLeftMargin",10)) ? GetScalar(tmp) : (m.seasonLeftMargin=1);
				o.seasonRightMargin=(tmp=GetField123Check(S,"seasonRightMargin",10)) ? GetScalar(tmp) : (m.seasonRightMargin=1);
			}
			o.trendMinOrder=(tmp=GetField123Check(S,"trendMinOrder",10)) ?   GetScalar(tmp) : (m.trendMinOrder=1);
			o.trendMaxOrder=(tmp=GetField123Check(S,"trendMaxOrder",10)) ?   GetScalar(tmp) : (m.trendMaxOrder=1);
			o.trendMinSepDist=(tmp=GetField123Check(S,"trendMinSepDist",10)) ?  GetScalar(tmp) : (m.trendMinSepDist=1);
			o.trendMinKnotNum=(tmp=GetField123Check(S,"trendMinKnotNum",10)) ?  GetScalar(tmp) : (m.trendMinKnotNum=1);			
			o.trendMaxKnotNum=(tmp=GetField123Check(S,"trendMaxKnotNum",10)) ?  GetScalar(tmp) : (m.trendMaxKnotNum=1);
			o.trendLeftMargin=(tmp=GetField123Check(S,"trendLeftMargin",10)) ? GetScalar(tmp) : (m.trendLeftMargin=1);
			o.trendRightMargin=(tmp=GetField123Check(S,"trendRightMargin",10)) ? GetScalar(tmp) : (m.trendRightMargin=1);
			if (io->meta.hasOutlierCmpnt) {
				o.outlierMinKnotNum=(tmp=GetField123Check(S,"outlierMinKnotNum",10)) ? GetScalar(tmp) : (m.outlierMinKnotNum=1);
				o.outlierMaxKnotNum=(tmp=GetField123Check(S,"outlierMaxKnotNum",10)) ? GetScalar(tmp) : (m.outlierMaxKnotNum=1);
				o.outlierSigFactor=(tmp=GetFieldCheck(S,"outlierSigFactor")) ? GetScalar(tmp) : (m.outlierSigFactor=1);
			}
			o.sigFactor=(tmp=GetFieldCheck(S,"sigFactor")) ?			GetScalar(tmp) : (m.sigFactor=1);
			o.sig2=(tmp=GetField123Check(S,"sig2",2)) ?			GetScalar(tmp) : (m.sig2=1);
			o.precValue=(tmp=GetField123Check(S,"precValue",5)) ?		GetScalar(tmp) : (m.precValue=1);
			o.alpha1=(tmp=GetField123Check(S,"alpha1",0)) ?			GetScalar(tmp) : (m.alpha1=1);
			o.alpha2=(tmp=GetField123Check(S,"alpha2",0)) ?			GetScalar(tmp) : (m.alpha2=1);
			o.delta1=(tmp=GetField123Check(S,"delta1",0)) ?			GetScalar(tmp) : (m.delta1=1);
			o.delta2=(tmp=GetField123Check(S,"delta2",0)) ?			GetScalar(tmp) : (m.delta2=1);
			o.K_MAX=(tmp=GetField123Check(S,"K_MAX",1)) ? GetScalar(tmp) : (m.K_MAX=1);
			if (io->meta.hasSeasonCmpnt)  o.seasonBasisFuncType=(tmp=GetField123Check(S,"seasonBasisFuncType",10)) ?  GetScalar(tmp) : (m.seasonBasisFuncType=1);
			if (1L)                       o.trendBasisFuncType=(tmp=GetField123Check(S,"trendBasisFuncType",10)) ?   GetScalar(tmp) : (m.trendBasisFuncType=1);
			if (io->meta.hasOutlierCmpnt) o.outlierBasisFuncType=(tmp=GetField123Check(S,"outlierBasisFuncType",10)) ? GetScalar(tmp) : (m.outlierBasisFuncType=1);
			o.modelPriorType=(tmp=GetField123Check(S,"modelPriorType",10)) ?		GetScalar(tmp) : (m.modelPriorType=1);
			o.precPriorType=__GetPrecPriorType(S);
		}
	} 
	o.numBasis=1L+io->meta.hasSeasonCmpnt+io->meta.hasOutlierCmpnt;
	I32  basisIdx=0;	
	if (io->meta.hasSeasonCmpnt) {
		I08      seasonFrom=io->meta.seasonForm;
		if      (seasonFrom=='S')	o.basisType[basisIdx++]=SEASONID;
		else if (seasonFrom=='D') o.basisType[basisIdx++]=DUMMYID;
		else if (seasonFrom=='V') o.basisType[basisIdx++]=SVDID;
		else {
			r_error("ERROR: the season character is unrecognized. Valid values are 'none','harmonic','dummy',and 'svd'. \n");
			return 0;
		}
	}
	o.basisType[basisIdx++]=TRENDID;
	if (io->meta.hasOutlierCmpnt) o.basisType[basisIdx++]=OUTLIERID;
	I32 period=io->meta.period;
	I32 N=io->N;
	if (io->meta.hasSeasonCmpnt) {
		if (io->meta.seasonForm=='S') {
			if (m.seasonMinOrder)      o.seasonMinOrder=1L;				   o.seasonMinOrder=min(o.seasonMinOrder,period/2 - 1);    o.seasonMinOrder=max(o.seasonMinOrder,1L);
			if (m.seasonMaxOrder)      o.seasonMaxOrder=(period/2 - 1);    o.seasonMaxOrder=min(o.seasonMaxOrder,(period/2 - 1));  o.seasonMaxOrder=max(o.seasonMaxOrder,o.seasonMinOrder);
		}	else if (io->meta.seasonForm=='V') {
			if (m.seasonMinOrder)      o.seasonMinOrder=1L;				   o.seasonMinOrder=min(o.seasonMinOrder,period - 1);   o.seasonMinOrder=max(o.seasonMinOrder,1L);
			if (m.seasonMaxOrder)      o.seasonMaxOrder=(period/2 - 1);    o.seasonMaxOrder=min(o.seasonMaxOrder,period );  o.seasonMaxOrder=max(o.seasonMaxOrder,o.seasonMinOrder);
		}
		if (m.seasonMinSepDist||o.seasonMinSepDist <=0)   o.seasonMinSepDist=period/2;         
		o.seasonMinSepDist=max(o.seasonMinSepDist,o.seasonMaxOrder);		 
		o.seasonMinSepDist=min(o.seasonMinSepDist,N/2 - 1       ); 
		if (m.seasonLeftMargin||o.seasonLeftMargin  < 0)   o.seasonLeftMargin=o.seasonMinSepDist;          
		if (m.seasonRightMargin||o.seasonRightMargin < 0)   o.seasonRightMargin=o.seasonMinSepDist;
		I32 Nleft=N - (1+o.seasonLeftMargin+o.seasonRightMargin);
		if (Nleft < 1) {
			if (N - (1+o.seasonMinSepDist * 2) < 1) {
				o.seasonLeftMargin=0;
				o.seasonRightMargin=0;
			} else {
				o.seasonLeftMargin=o.seasonMinSepDist;
				o.seasonRightMargin=o.seasonMinSepDist;
			}
			q_warning("WARNING: prior$seasonLeftMargin and prior$seasonRightMargin are too large,and no remaining data points are "
				      "available as potential changepoints! Their vaules are changed to %d and %d.",o.seasonLeftMargin,o.seasonRightMargin);
			Nleft=N - (1+o.seasonLeftMargin+o.seasonRightMargin);
		}
		I32 MaxChangePointPossible=ceil((Nleft+0.0)/(o.seasonMinSepDist+1.0));
		if (m.seasonMinKnotNum   )   o.seasonMinKnotNum=0;                  
		if (m.seasonMaxKnotNum==0)   o.seasonMinKnotNum=min(o.seasonMaxKnotNum,o.seasonMinKnotNum);
		o.seasonMinKnotNum=max(o.seasonMinKnotNum,0);
		o.seasonMinKnotNum=min(o.seasonMinKnotNum,MaxChangePointPossible);
		if (m.seasonMaxKnotNum)     o.seasonMaxKnotNum=min(MaxChangePointPossible,5);
		o.seasonMaxKnotNum=min(o.seasonMaxKnotNum,MaxChangePointPossible);
		o.seasonMaxKnotNum=max(o.seasonMaxKnotNum,o.seasonMinKnotNum);
	}
	{ 
		if (m.trendMinOrder||o.trendMinOrder < 0)      o.trendMinOrder=0L;
		if (m.trendMaxOrder)                             o.trendMaxOrder=1L;				                    
		o.trendMaxOrder=max(o.trendMaxOrder,o.trendMinOrder);	
		if (m.trendMinSepDist||o.trendMinSepDist <=0) o.trendMinSepDist=io->meta.hasSeasonCmpnt? period/2: 3 ;
		o.trendMinSepDist=max(o.trendMinSepDist,o.trendMaxOrder+1);
		o.trendMinSepDist=min(o.trendMinSepDist,N/2 - 1);
		if (m.trendLeftMargin||o.trendLeftMargin < 0)     o.trendLeftMargin=o.trendMinSepDist;
		if (m.trendRightMargin||o.trendRightMargin < 0)    o.trendRightMargin=o.trendMinSepDist;
		I32 Nleft=N - (1+o.trendLeftMargin+o.trendRightMargin);
		if (Nleft < 1) {
			if (N - (1+o.trendMinSepDist * 2) < 1) {
				o.trendLeftMargin=0;
				o.trendRightMargin=0;
			}
			else {
				o.trendLeftMargin=o.trendMinSepDist;
				o.trendRightMargin=o.trendMinSepDist;
			}
			q_warning("WARNING: prior$trendLeftMargin and prior$trendRightMargin are too large,and no remaining data points are "
				"available as potential changepoints! Their vaules are changed to %d and %d.",o.trendRightMargin,o.trendRightMargin);
			Nleft=N - (1+o.trendLeftMargin+o.trendRightMargin);
		}
		I32 MaxChangePointPossible=ceil((Nleft+0.0)/(o.trendMinSepDist+1.0));
		if (m.trendMinKnotNum)       o.trendMinKnotNum=0;	   
		o.trendMinKnotNum=max(min(o.trendMaxKnotNum,o.trendMinKnotNum),0);
		if (m.trendMinKnotNum)        o.trendMinKnotNum=0;
		if (m.trendMaxKnotNum==0)   o.trendMinKnotNum=min(o.trendMinKnotNum,o.trendMaxKnotNum);
		o.trendMinKnotNum=max(o.trendMinKnotNum,0);
		o.trendMinKnotNum=min(o.trendMinKnotNum,MaxChangePointPossible);
		if (m.trendMaxKnotNum)     o.trendMaxKnotNum=min(MaxChangePointPossible,10);
		o.trendMaxKnotNum=min(o.trendMaxKnotNum,MaxChangePointPossible);
		o.trendMaxKnotNum=max(o.trendMaxKnotNum,o.trendMinKnotNum);	 
	}
	if (m.outlierMinKnotNum) o.outlierMinKnotNum=0;
	if (m.outlierMaxKnotNum) o.outlierMaxKnotNum=o.trendMaxKnotNum;    
	if (m.K_MAX )            o.K_MAX=0;    
	if (m.sigFactor)         o.sigFactor=1.8;            o.sigFactor=max(o.sigFactor,1.02);
	if (m.outlierSigFactor)  o.outlierSigFactor=2.5;            o.outlierSigFactor=max(o.outlierSigFactor,1.5);
	if (m.sig2 )             o.sig2=0.2f;				  o.sig2=max(o.sig2,0.01);
	if (m.precValue)         o.precValue=1.5f;				  o.precValue=max(o.precValue,1e-32);
	if (m.alpha1)		     o.alpha1=0.00000001f;
	if (m.alpha2)		     o.alpha2=0.00000001f;
	if (m.delta1)		     o.delta1=0.00000001f;
	if (m.delta2)		     o.delta2=0.00000001f;
	if (m.precPriorType)			o.precPriorType=UniformPrec;
	if (m.seasonBasisFuncType) {
		if      (o.precPriorType==UniformPrec)		o.seasonBasisFuncType=0;
		else if (o.precPriorType==ConstPrec)          o.seasonBasisFuncType=0;
		else if (o.precPriorType==ComponentWise)      o.seasonBasisFuncType=1;
		else if (o.precPriorType==OrderWise)          o.seasonBasisFuncType=1;		
	}
	if (m.trendBasisFuncType) {
		if      (o.precPriorType==UniformPrec)		o.trendBasisFuncType=0;
		else if (o.precPriorType==ConstPrec)          o.trendBasisFuncType=0;
		else if (o.precPriorType==ComponentWise)      o.trendBasisFuncType=1;
		else if (o.precPriorType==OrderWise)          o.trendBasisFuncType=1;
	}	 
	if (m.outlierBasisFuncType) {
		if      (o.precPriorType==UniformPrec)		o.outlierBasisFuncType=0;
		else if (o.precPriorType==ConstPrec)          o.outlierBasisFuncType=0;
		else if (o.precPriorType==ComponentWise)      o.outlierBasisFuncType=1;
		else if (o.precPriorType==OrderWise)          o.outlierBasisFuncType=1;
	}	 
	if (m.modelPriorType)			o.modelPriorType=1L;
	return 1;
#undef o
}
static int  GetArg_3rd_MCMC___(VOIDPTR prhs[],int nrhs,BEAST2_MCMC_PTR mcmc,BEAST2_OPTIONS_PTR opt)
{
	#define o (*mcmc)
	struct MCMC_MISSING {
		U08   seed;	                  
		U08   credIntervalAlphaLevel;
		U08   trendResamplingOrderProb;
		U08   seasonResamplingOrderProb;
		U08   ridgeFactor;
		U08   burnin,samples,chainNumber;
		U08   maxMoveStepSize;
		U08   thinningFactor;
	} m={0,};
	if (nrhs < 5) 
		memset(&m,1L,sizeof(struct MCMC_MISSING));
	if (nrhs >=5) {
		VOIDPTR S=prhs[4L];
		if (!IsStruct(S)) {
			q_warning("WARNING: The arg 'mcmc' is ignored because it is not a LIST variable.");
			memset(&m,1L,sizeof(struct MCMC_MISSING));
		} else {
			VOIDPTR tmp;
			o.maxMoveStepSize=(tmp=GetField123Check(S,"maxMoveStepSize",2))? GetScalar(tmp) : (m.maxMoveStepSize=1);
			o.samples=(tmp=GetField123Check(S,"samples",3)) ?        GetScalar(tmp) : (m.samples=1);
			o.thinningFactor=(tmp=GetField123Check(S,"thinningFactor",2)) ? GetScalar(tmp) : (m.thinningFactor=1);
			o.burnin=(tmp=GetField123Check(S,"burnin",2)) ?         GetScalar(tmp) : (m.burnin=1);
			o.chainNumber=(tmp=GetField123Check(S,"chainNumber",2)) ?    GetScalar(tmp) : (m.chainNumber=1);
			o.seed=(tmp=GetField123Check(S,"seed",4)) ?			GetScalar(tmp) : (m.seed=1);
			o.ridgeFactor=(tmp=GetField123Check(S,"ridgeFactor",2)) ?	GetScalar(tmp) : (m.ridgeFactor=1);
			o.trendResamplingOrderProb=(tmp=GetField123Check(S,"trendResamplingOrderProb",5)) ? GetScalar(tmp) : (m.trendResamplingOrderProb=1);
			o.seasonResamplingOrderProb=(tmp=GetField123Check(S,"seasonResamplingOrderProb",5)) ? GetScalar(tmp) : (m.seasonResamplingOrderProb=1);
			o.credIntervalAlphaLevel=(tmp=GetField123Check(S,"credIntervalAlphaLevel",2)) ? GetScalar(tmp) : (m.credIntervalAlphaLevel=1);
		}
	} 
	if (m.maxMoveStepSize||o.maxMoveStepSize==0) o.maxMoveStepSize=opt->io.meta.hasSeasonCmpnt? opt->io.meta.period: (opt->prior.trendMinSepDist+1);
	if (m.samples||o.samples==0)		   o.samples=3000;        o.samples=max(o.samples,800);
	if (m.thinningFactor||o.thinningFactor==0)  o.thinningFactor=1L;			o.thinningFactor=max(o.thinningFactor,1L);
	if (m.burnin||o.burnin==0)          o.burnin=150L;		o.burnin=max(o.burnin,150L);
	if (m.chainNumber||o.chainNumber==0)         o.chainNumber=3;			o.chainNumber=max(o.chainNumber,1L);
	if (m.seed)            o.seed=0L;
	if (m.credIntervalAlphaLevel)      o.credIntervalAlphaLevel=.95;
	if (m.ridgeFactor)     o.ridgeFactor=0.0001f;
	if (m.trendResamplingOrderProb)  o.trendResamplingOrderProb=.1f;
	if (m.seasonResamplingOrderProb) o.seasonResamplingOrderProb=.17f;
	return 1;
#undef o
}
static int  GetArg_4th_EXTRA__(VOIDPTR prhs[],int nrhs,BEAST2_EXTRA_PTR extra,I32 whichDimIsTime,I32 ndims)
{
	#define o (*extra)
	struct OUTFLAGS_MISSING {
		I08   numThreadsPerCPU;
		I08   numParThreads;
		I08   numCPUCoresToUse;		
		I08   consoleWidth;
		I08   whichOutputDimIsTime;
		I08   removeSingletonDims;
		I08   dumpInputData;
		I08  smoothCpOccPrCurve;
		I08  useRndBeta;
		I08  computeCredible;
		I08  fastCIComputation;
		I08  computeSeasonOrder;
		I08  computeTrendOrder;
		I08  computeSeasonChngpt;
		I08  computeTrendChngpt;
		I08  computeOutlierChngpt;
		I08  computeSeasonAmp;
		I08  computeTrendSlope;
		I08 tallyPosNegSeasonJump;
		I08 tallyPosNegTrendJump;
		I08 tallyIncDecTrendJump;
		I08 tallyPosNegOutliers;
		I08 dumpMCMCSamples;
	} m={0,};
	if (nrhs < 6) 
		memset(&m,1L,sizeof(struct OUTFLAGS_MISSING));	
	if (nrhs >=6) {
		VOIDPTR S=prhs[5L];
		if (!IsStruct(S)) {
			q_warning("WARNING: The arg 'extra' is ignored because it is not a LIST variable.");
			memset(&m,1L,sizeof(struct OUTFLAGS_MISSING));
		}
		else {
			VOIDPTR tmp;
			o.whichOutputDimIsTime=(tmp=GetField123Check(S,"whichOutputDimIsTime",2)) ? GetScalar(tmp) : (m.whichOutputDimIsTime=1);
			o.removeSingletonDims=(tmp=GetField123Check(S,"removeSingletonDims",8)) ? GetScalar(tmp) : (m.removeSingletonDims=1);			
			o.numThreadsPerCPU=(tmp=GetField123Check(S,"numThreadsPerCPU",4))    ? GetScalar(tmp) : (m.numThreadsPerCPU=1);
			o.numParThreads=(tmp=GetField123Check(S,"numParThreads",4))       ? GetScalar(tmp) : (m.numParThreads=1);
			o.numCPUCoresToUse=(tmp=GetField123Check(S,"numCPUCoresToUse",4))    ? GetScalar(tmp) : (m.numCPUCoresToUse=1);
			o.consoleWidth=(tmp=GetField123Check(S,"consoleWidth",2))         ? GetScalar(tmp) : (m.consoleWidth=1);
			o.dumpInputData=(tmp=GetField123Check(S,"dumpInputData",5))        ? GetScalar(tmp) : (m.dumpInputData=1);
			o.smoothCpOccPrCurve=(tmp=GetField123Check(S,"smoothCpOccPrCurve",2))   ? GetScalar(tmp) : (m.smoothCpOccPrCurve=1);
			o.dumpMCMCSamples=(tmp=GetField123Check(S,"dumpMCMCSamples",7))     ? GetScalar(tmp) : (m.dumpMCMCSamples=1);
			#define _1(x)       o.x=(tmp=GetFieldCheck(S,#x))? GetScalar(tmp): (m.x=1)
			#define _2(x,y)     _1(x);_1(y)
			#define _3(x,y,z)   _1(x);_2(y,z)
			#define _4(x,y,z,w) _2(x,y);_2(z,w)
			_2(computeCredible,fastCIComputation);
			_2(computeSeasonOrder,computeTrendOrder);
			_3(computeSeasonChngpt,computeTrendChngpt,computeOutlierChngpt);
			_2(computeSeasonAmp,computeTrendSlope);
			_4(tallyPosNegSeasonJump,tallyPosNegTrendJump,tallyIncDecTrendJump,tallyPosNegOutliers);
			_1(useRndBeta);
		} 
	} 
	if (m.whichOutputDimIsTime)		o.whichOutputDimIsTime=whichDimIsTime;
	if (m.removeSingletonDims)		o.removeSingletonDims=1;
	if (o.whichOutputDimIsTime > ndims)		o.whichOutputDimIsTime=1L; 
	if (m.smoothCpOccPrCurve)    o.smoothCpOccPrCurve=0;
	if (m.dumpInputData)		 o.dumpInputData=0;
	if (m.numThreadsPerCPU)      o.numThreadsPerCPU=2;
	if (m.numParThreads)         o.numParThreads=0;
	if (m.numCPUCoresToUse)      o.numCPUCoresToUse=0;	
	if (m.consoleWidth||o.consoleWidth<=0)  o.consoleWidth=GetConsoleWidth(); 	o.consoleWidth=max(o.consoleWidth,40);
	if (m.computeCredible)       o.computeCredible=0L;
	if (m.fastCIComputation)     o.fastCIComputation=1L;
	if (m.computeSeasonOrder)    o.computeSeasonOrder=0L;
	if (m.computeTrendOrder)     o.computeTrendOrder=0L;
	if (m.computeSeasonChngpt)   o.computeSeasonChngpt=1L;
	if (m.computeTrendChngpt)    o.computeTrendChngpt=1L;
	if (m.computeOutlierChngpt)  o.computeOutlierChngpt=1L;
	if (m.computeSeasonAmp)       o.computeSeasonAmp=0L;
	if (m.computeTrendSlope)      o.computeTrendSlope=0L;
	if (m.tallyPosNegSeasonJump)     o.tallyPosNegSeasonJump=0L;
	if (m.tallyPosNegTrendJump)      o.tallyPosNegTrendJump=0L;
	if (m.tallyIncDecTrendJump)      o.tallyIncDecTrendJump=0L;
	if (m.tallyPosNegOutliers)       o.tallyPosNegOutliers=0L;
	if (o.tallyPosNegSeasonJump) o.computeSeasonChngpt=1,o.computeSeasonAmp=1;
	if (o.tallyPosNegTrendJump)  o.computeTrendChngpt=1,o.computeTrendSlope=1;
	if (o.tallyIncDecTrendJump)  o.computeTrendChngpt=1,o.computeTrendSlope=1;
	if (o.tallyPosNegOutliers)   o.computeOutlierChngpt=1;
	if (m.useRndBeta)      o.useRndBeta=0;
	if (m.dumpMCMCSamples) o.dumpMCMCSamples=0;
	return 1;
#undef o
}
I32 PostCheckArgs(A(OPTIONS_PTR) opt) {
	I08 hasSeasonCmpnt=opt->prior.basisType[0]==SEASONID||opt->prior.basisType[0]==DUMMYID||opt->prior.basisType[0]==SVDID;
	I08 hasHarmonicCmpnt=opt->prior.basisType[0]==SEASONID ;
	I08 hasDummyCmpnt=opt->prior.basisType[0]==DUMMYID;
	I08 hasSVDCmpnt=opt->prior.basisType[0]==SVDID;
	I08 hasOutlierCmpnt=opt->prior.basisType[opt->prior.numBasis - 1]==OUTLIERID;
	I08 hasTrendCmpnt=1;
	I08 hasAlways=1;
	if (hasOutlierCmpnt ) {
		if (opt->prior.outlierMinKnotNum > opt->io.N/2) {
			opt->prior.outlierMinKnotNum=opt->io.N/2;
		}
		if (opt->prior.outlierMaxKnotNum <=0||opt->prior.outlierMaxKnotNum < opt->prior.outlierMinKnotNum) {
			hasOutlierCmpnt=0;			
			opt->io.meta.hasOutlierCmpnt=0;
			opt->prior.numBasis--;
		}		
	}
	if (hasDummyCmpnt) opt->io.meta.period=ceil(opt->io.meta.period);
	if (opt->prior.trendMaxOrder==opt->prior.trendMinOrder)	opt->mcmc.trendResamplingOrderProb=0;
	if (opt->prior.seasonMaxOrder==opt->prior.seasonMinOrder)	opt->mcmc.seasonResamplingOrderProb=0;
	if (hasDummyCmpnt)											opt->mcmc.seasonResamplingOrderProb=0;
	if (opt->io.meta.deseasonalize && !hasSeasonCmpnt) {
		opt->io.meta.deseasonalize=0;		
	}
	if(opt->io.meta.period+3  > opt->io.N) {
		opt->io.meta.deseasonalize=0;
	}
	if (!hasSeasonCmpnt) {
		opt->extra.computeSeasonOrder=0;
		opt->extra.computeSeasonChngpt=0;
		opt->extra.computeSeasonAmp=0;
		opt->extra.tallyPosNegSeasonJump=0;
	}
	if (hasDummyCmpnt) {
		opt->extra.computeSeasonOrder=0;	
		opt->extra.computeSeasonAmp=0; 
		opt->prior.seasonMinOrder=0;
		opt->prior.seasonMaxOrder=0;		
	}
	if (hasSVDCmpnt) { 
		opt->extra.computeSeasonAmp=0; 
		opt->extra.tallyPosNegSeasonJump=0;
	}
	if (!hasOutlierCmpnt) {
		opt->extra.computeOutlierChngpt=0;
		opt->extra.tallyPosNegOutliers=0;
	}
	BEAST2_PRIOR_PTR PRIOR=&opt->prior;
	#define prior (*PRIOR)
	I08  isTrendCmpntFixed=prior.trendMaxOrder==prior.trendMinOrder  && prior.trendMaxKnotNum==0 && prior.trendMinKnotNum==0;
	I08  isSeasonCmpntFixed=prior.seasonMaxOrder==prior.seasonMinOrder && prior.seasonMaxKnotNum==0 && prior.seasonMinKnotNum==0;
	if (hasDummyCmpnt) isSeasonCmpntFixed=prior.seasonMaxKnotNum==0 && prior.seasonMinKnotNum==0;
	#undef prior
	if (opt->prior.numBasis==2 ) {
		if (hasTrendCmpnt  && hasOutlierCmpnt && isTrendCmpntFixed) {
			q_warning("WARNING: The options 'trendMaxOrder==trendMaxOrder && trendMaxKnotNum==0 && trendMinKnotNum==0' will"
				     " fix the trend to a global curve.\n");					 
		}
		if (hasHarmonicCmpnt && hasOutlierCmpnt && isSeasonCmpntFixed) {
			q_warning("WARNING: The options 'seasonMaxOrder==seasonMaxOrder && seasonMaxKnotNum==0 && seasonMinKnotNum==0' will"
				    " fix the season component to a global curve.\n");		 
		}
		if (hasDummyCmpnt && hasOutlierCmpnt && isSeasonCmpntFixed) {
			q_warning("WARNING: The options 'seasonMaxKnotNum==0 && seasonMinKnotNum==0' will"
				    " fix the dummy season component to a global curve.\n");			
		}
	}
	if (hasTrendCmpnt && hasDummyCmpnt & isTrendCmpntFixed && isSeasonCmpntFixed) {		
		q_warning("WARNING: The options 'trendMaxOrder==trendMaxOrder && trendMaxKnotNum==0 && trendMinKnotNum==0 && "
			    " seasonMaxKnotNum==0 && seasonMinKnotNum==0' will"
			    " fix the model structures of the trend and dummy season components.\n");
	}
	if (hasTrendCmpnt && hasHarmonicCmpnt & isTrendCmpntFixed && isSeasonCmpntFixed) {
		q_warning("WARNING: The options 'trendMaxOrder==trendMaxOrder && trendMaxKnotNum==0 && trendMinKnotNum==0 && "
			    "seasonMaxOrder==seasonMaxOrder && seasonMaxKnotNum==0 && seasonMinKnotNum==0' will"
			    " fix the model structures of the trend and harmonic season components.\n"); 
	}
	I32 KMAX=0;
	for (I32 i=0; i < PRIOR->numBasis; i++) {		
		I08 type=PRIOR->basisType[i];
		if (type==SEASONID)			KMAX+=(PRIOR->seasonMaxOrder*2) * (PRIOR->seasonMaxKnotNum+1);
		if (type==DUMMYID)			KMAX+=(opt->io.meta.period)     * (PRIOR->seasonMaxKnotNum+1);
		if (type==SVDID)			    KMAX+=(opt->io.meta.period)     * (PRIOR->seasonMaxKnotNum+1);
		if (type==TRENDID)			KMAX+=(PRIOR->trendMaxOrder+1) * (PRIOR->trendMaxKnotNum+1);
		if (type==OUTLIERID)			KMAX+=PRIOR->outlierMaxKnotNum;
	}
	if (PRIOR->K_MAX <=0) {  
		PRIOR->K_MAX=KMAX;
	} else {
		PRIOR->K_MAX=min(PRIOR->K_MAX,KMAX);
	}
	if (opt->io.N < 5000)
		PRIOR->K_MAX=min(PRIOR->K_MAX,opt->io.N);
	else if (opt->io.N < 15000) {
		int KMAX=min(5000,opt->io.N/2);
		PRIOR->K_MAX=min(PRIOR->K_MAX,KMAX);
	}
	else  {
		int KMAX=7500;
		PRIOR->K_MAX=min(PRIOR->K_MAX,KMAX);
	}
	I32 K_INITIAL_MODEL=0;
	for (I32 i=0; i < PRIOR->numBasis; i++) {
		I08 type=PRIOR->basisType[i];
		if (type==SEASONID) {
			I32 order=ceil((PRIOR->seasonMaxOrder+PRIOR->seasonMinOrder)/2.0);
			I32 nKnot=ceil((PRIOR->seasonMinKnotNum+PRIOR->seasonMaxKnotNum)/2.0);   
			K_INITIAL_MODEL+=(order * 2) * (nKnot+1);
		}
		if (type==DUMMYID) {
			I32 order=ceil(opt->io.meta.period);
			I32 nKnot=ceil((PRIOR->seasonMinKnotNum+PRIOR->seasonMaxKnotNum)/2.0);   
			K_INITIAL_MODEL+=(order ) * (nKnot+1);
		}
		if (type==SVDID) {
			I32 order=ceil(opt->io.meta.period);
			I32 nKnot=ceil((PRIOR->seasonMinKnotNum+PRIOR->seasonMaxKnotNum)/2.0);   
			K_INITIAL_MODEL+=(order) * (nKnot+1);
		}
		if (type==TRENDID)		{
			I32 order=ceil((PRIOR->trendMaxOrder+PRIOR->trendMinOrder)/2.0);
			I32 nKnot=ceil((PRIOR->trendMinKnotNum+PRIOR->trendMaxKnotNum)/2.0);   
			K_INITIAL_MODEL+=(order+1L) * (nKnot+1);
		}
		if (type==OUTLIERID) {
			K_INITIAL_MODEL+=0;
		}
	}
	PRIOR->K_MAX=max(PRIOR->K_MAX,K_INITIAL_MODEL);
	opt->io.out.dtype=IsRinterface() ? DATA_DOUBLE : DATA_FLOAT;
	opt->io.out.whichDimIsTime=opt->extra.whichOutputDimIsTime;
	if (opt->prior.precPriorType==ComponentWise && opt->prior.numBasis==1) {
		opt->prior.precPriorType=UniformPrec;
	}
	if (opt->io.numOfPixels > 1) {
		opt->extra.dumpMCMCSamples=0;
	}
	if (opt->prior.numBasis==1 && opt->prior.precPriorType==ComponentWise) {	
		opt->prior.precPriorType=UniformPrec;
	}
	opt->extra.printProgress=GLOBAL_PRNT_PROGRESS;
	return 1;
}
int BEAST2_GetArgs(VOIDPTR prhs[],int nrhs,A(OPTIONS_PTR) opt) {
	int  failed=!GetArg_0th_Data(prhs,nrhs,&opt->io)||
		          !GetArg_1st_MetaData(prhs,nrhs,&opt->io)|| 				  
			      !GetArg_2nd_Prior__(prhs,nrhs,&opt->prior,&opt->io)||
			      !GetArg_3rd_MCMC___(prhs,nrhs,&opt->mcmc,opt)||
			      !GetArg_4th_EXTRA__(prhs,nrhs,&opt->extra,opt->io.meta.whichDimIsTime,opt->io.ndim) ;
	int success=!failed;	
	if (success)  success=PostCheckArgs(opt); 	
	if (success && GLOBAL_PRNT_PARAMETER) {
		BEAST2_print_options(opt);
	}	
	return success;
}
void BEAST2_DeallocateTimeSeriesIO(BEAST2_IO_PTR  o) {
	if (o->T.out.numPtsPerInterval !=NULL) {
		free(o->T.out.numPtsPerInterval);
		o->T.out.numPtsPerInterval=NULL;
	}
	TimeVec_kill(&o->T);
	if (o->pdata !=NULL) {
		free(o->pdata);
		o->pdata=NULL;
	}
	if (o->dtype !=NULL) {
		free(o->dtype);
		o->dtype=NULL;
	}
	if (o->out.result !=NULL) {
		free(o->out.result);
		o->out.result=NULL;
	}
}
#include "abc_000_warning.h"
