#' @title MRS data
#' @description A dataset containing the mass, speed and hopper indicator for land animals.
#'  The variables are as follows:
#'
#' @format A data frame with 107 rows and 3 variables
#'\describe{
#'   \item{mass}{the mass of animals}
#'   \item{speed}{the speed of animals}
#'   \item{hopper}{the indicator variabel of hoppers}
#' }
#' @source Garland, T.(1983).
#' @docType data
#' @keywords data_mrs
#' @usage data(data_mrs)
#'
#' @references
#' \itemize{
#' \item Garland, T.(1983).
#'   The relation between maximal running speed and body
#'   mass in terrestrial mammals. Journal of Zoology 199, 157--170.
#'   }
#'
#' @examples
#' \dontrun{
#' data(data_mrs)
#' summary(data_mrs)
#' }

"data_mrs"
