% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bds.R
\name{bds}
\alias{bds}
\title{Run 'Bloomberg Data Set' Queries}
\usage{
bds(security, field, options = NULL, overrides = NULL, verbose = FALSE,
  identity = defaultAuthentication(), con = defaultConnection(),
  simplify = getOption("blpSimplify", TRUE))
}
\arguments{
\item{security}{A character value with a single security symbol in
Bloomberg notation.}

\item{field}{A character string with a single Bloomberg query field.}

\item{options}{An optional named character vector with option
values. Each field must have both a name (designating the option
being set) as well as a value.}

\item{overrides}{An optional named character vector with override
values. Each field must have both a name (designating the override
being set) as well as a value.}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{identity}{An optional identity object as created by a
\code{blpAuthenticate} call, and retrived via the internal function
\code{defaultAuthentication}.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}

\item{simplify}{A boolean indicating whether result objects that are one
element lists should be altered to returned just the single inner object.
Defaults to the value of the \sQuote{blpSimplify} option, with a fallback
of \sQuote{TRUE} if unset ensuring prior behavior is maintained.}
}
\value{
A data frame object with the requested data set.
}
\description{
This function uses the Bloomberg API to retrieve 'bds' (Bloomberg
Data Set) queries
}
\examples{
\dontrun{
  ## simple query
  bds("GOOG US Equity", "TOP_20_HOLDERS_PUBLIC_FILINGS")
  ## example of using overrides
  overrd <- c("START_DT"="20150101", "END_DT"="20160101")
  bds("CPI YOY Index","ECO_RELEASE_DT_LIST", overrides = overrd)
}
}
\author{
Whit Armstrong and Dirk Eddelbuettel
}
